@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.alicloud.amqp.QueueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RabbitMQ (AMQP) Queue resource.
 * For information about RabbitMQ (AMQP) Queue and how to use it, see [What is Queue](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createqueue).
 * > **NOTE:** Available since v1.127.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.amqp.Instance("default", {
 *     instanceType: "enterprise",
 *     maxTps: "3000",
 *     queueCapacity: "200",
 *     storageSize: "700",
 *     supportEip: false,
 *     maxEipTps: "128",
 *     paymentType: "Subscription",
 *     period: 1,
 * });
 * const defaultVirtualHost = new alicloud.amqp.VirtualHost("default", {
 *     instanceId: _default.id,
 *     virtualHostName: "tf-example",
 * });
 * const defaultExchange = new alicloud.amqp.Exchange("default", {
 *     autoDeleteState: false,
 *     exchangeName: "tf-example",
 *     exchangeType: "DIRECT",
 *     instanceId: _default.id,
 *     internal: false,
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 * });
 * const example = new alicloud.amqp.Queue("example", {
 *     instanceId: _default.id,
 *     queueName: "tf-example",
 *     virtualHostName: defaultVirtualHost.virtualHostName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.amqp.Instance("default",
 *     instance_type="enterprise",
 *     max_tps="3000",
 *     queue_capacity="200",
 *     storage_size="700",
 *     support_eip=False,
 *     max_eip_tps="128",
 *     payment_type="Subscription",
 *     period=1)
 * default_virtual_host = alicloud.amqp.VirtualHost("default",
 *     instance_id=default.id,
 *     virtual_host_name="tf-example")
 * default_exchange = alicloud.amqp.Exchange("default",
 *     auto_delete_state=False,
 *     exchange_name="tf-example",
 *     exchange_type="DIRECT",
 *     instance_id=default.id,
 *     internal=False,
 *     virtual_host_name=default_virtual_host.virtual_host_name)
 * example = alicloud.amqp.Queue("example",
 *     instance_id=default.id,
 *     queue_name="tf-example",
 *     virtual_host_name=default_virtual_host.virtual_host_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Amqp.Instance("default", new()
 *     {
 *         InstanceType = "enterprise",
 *         MaxTps = "3000",
 *         QueueCapacity = "200",
 *         StorageSize = "700",
 *         SupportEip = false,
 *         MaxEipTps = "128",
 *         PaymentType = "Subscription",
 *         Period = 1,
 *     });
 *     var defaultVirtualHost = new AliCloud.Amqp.VirtualHost("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = "tf-example",
 *     });
 *     var defaultExchange = new AliCloud.Amqp.Exchange("default", new()
 *     {
 *         AutoDeleteState = false,
 *         ExchangeName = "tf-example",
 *         ExchangeType = "DIRECT",
 *         InstanceId = @default.Id,
 *         Internal = false,
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *     });
 *     var example = new AliCloud.Amqp.Queue("example", new()
 *     {
 *         InstanceId = @default.Id,
 *         QueueName = "tf-example",
 *         VirtualHostName = defaultVirtualHost.VirtualHostName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amqp.NewInstance(ctx, "default", &amqp.InstanceArgs{
 * 			InstanceType:  pulumi.String("enterprise"),
 * 			MaxTps:        pulumi.String("3000"),
 * 			QueueCapacity: pulumi.String("200"),
 * 			StorageSize:   pulumi.String("700"),
 * 			SupportEip:    pulumi.Bool(false),
 * 			MaxEipTps:     pulumi.String("128"),
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVirtualHost, err := amqp.NewVirtualHost(ctx, "default", &amqp.VirtualHostArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewExchange(ctx, "default", &amqp.ExchangeArgs{
 * 			AutoDeleteState: pulumi.Bool(false),
 * 			ExchangeName:    pulumi.String("tf-example"),
 * 			ExchangeType:    pulumi.String("DIRECT"),
 * 			InstanceId:      _default.ID(),
 * 			Internal:        pulumi.Bool(false),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewQueue(ctx, "example", &amqp.QueueArgs{
 * 			InstanceId:      _default.ID(),
 * 			QueueName:       pulumi.String("tf-example"),
 * 			VirtualHostName: defaultVirtualHost.VirtualHostName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.amqp.Instance;
 * import com.pulumi.alicloud.amqp.InstanceArgs;
 * import com.pulumi.alicloud.amqp.VirtualHost;
 * import com.pulumi.alicloud.amqp.VirtualHostArgs;
 * import com.pulumi.alicloud.amqp.Exchange;
 * import com.pulumi.alicloud.amqp.ExchangeArgs;
 * import com.pulumi.alicloud.amqp.Queue;
 * import com.pulumi.alicloud.amqp.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceType("enterprise")
 *             .maxTps(3000)
 *             .queueCapacity(200)
 *             .storageSize(700)
 *             .supportEip(false)
 *             .maxEipTps(128)
 *             .paymentType("Subscription")
 *             .period(1)
 *             .build());
 *         var defaultVirtualHost = new VirtualHost("defaultVirtualHost", VirtualHostArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName("tf-example")
 *             .build());
 *         var defaultExchange = new Exchange("defaultExchange", ExchangeArgs.builder()
 *             .autoDeleteState(false)
 *             .exchangeName("tf-example")
 *             .exchangeType("DIRECT")
 *             .instanceId(default_.id())
 *             .internal(false)
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .build());
 *         var example = new Queue("example", QueueArgs.builder()
 *             .instanceId(default_.id())
 *             .queueName("tf-example")
 *             .virtualHostName(defaultVirtualHost.virtualHostName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:amqp:Instance
 *     properties:
 *       instanceType: enterprise
 *       maxTps: 3000
 *       queueCapacity: 200
 *       storageSize: 700
 *       supportEip: false
 *       maxEipTps: 128
 *       paymentType: Subscription
 *       period: 1
 *   defaultVirtualHost:
 *     type: alicloud:amqp:VirtualHost
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: tf-example
 *   defaultExchange:
 *     type: alicloud:amqp:Exchange
 *     name: default
 *     properties:
 *       autoDeleteState: false
 *       exchangeName: tf-example
 *       exchangeType: DIRECT
 *       instanceId: ${default.id}
 *       internal: false
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 *   example:
 *     type: alicloud:amqp:Queue
 *     properties:
 *       instanceId: ${default.id}
 *       queueName: tf-example
 *       virtualHostName: ${defaultVirtualHost.virtualHostName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RabbitMQ (AMQP) Queue can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/queue:Queue example <instance_id>:<virtual_host_name>:<queue_name>
 * ```
 * @property autoDeleteState Specifies whether the Auto Delete attribute is configured. Valid values:
 * * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
 * * false: The Auto Delete attribute is not configured.
 * @property autoExpireState The validity period after which the queue is automatically deleted.
 * If the queue is not accessed within a specified period of time, it is automatically deleted.
 * @property deadLetterExchange The dead-letter exchange. A dead-letter exchange is used to receive rejected messages.
 * If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
 * Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
 * @property deadLetterRoutingKey The dead letter routing key.
 * @property exclusiveState Specifies whether the queue is an exclusive queue. Valid values:
 * * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
 * * false: The queue is not an exclusive queue.
 * @property instanceId The ID of the instance.
 * @property maxLength The maximum number of messages that can be stored in the queue.
 * If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
 * @property maximumPriority The highest priority supported by the queue. This parameter is set to a positive integer.
 * Valid values: 0 to 255. Recommended values: 1 to 10
 * @property messageTtl The message TTL of the queue.
 * If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
 * Message TTL must be set to a non-negative integer, in milliseconds.
 * For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
 * @property queueName The name of the queue.
 * The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
 * @property virtualHostName The name of the virtual host.
 */
public data class QueueArgs(
    public val autoDeleteState: Output<Boolean>? = null,
    public val autoExpireState: Output<String>? = null,
    public val deadLetterExchange: Output<String>? = null,
    public val deadLetterRoutingKey: Output<String>? = null,
    public val exclusiveState: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val maxLength: Output<String>? = null,
    public val maximumPriority: Output<Int>? = null,
    public val messageTtl: Output<String>? = null,
    public val queueName: Output<String>? = null,
    public val virtualHostName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.QueueArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.QueueArgs =
        com.pulumi.alicloud.amqp.QueueArgs.builder()
            .autoDeleteState(autoDeleteState?.applyValue({ args0 -> args0 }))
            .autoExpireState(autoExpireState?.applyValue({ args0 -> args0 }))
            .deadLetterExchange(deadLetterExchange?.applyValue({ args0 -> args0 }))
            .deadLetterRoutingKey(deadLetterRoutingKey?.applyValue({ args0 -> args0 }))
            .exclusiveState(exclusiveState?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .maxLength(maxLength?.applyValue({ args0 -> args0 }))
            .maximumPriority(maximumPriority?.applyValue({ args0 -> args0 }))
            .messageTtl(messageTtl?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .virtualHostName(virtualHostName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueArgs].
 */
@PulumiTagMarker
public class QueueArgsBuilder internal constructor() {
    private var autoDeleteState: Output<Boolean>? = null

    private var autoExpireState: Output<String>? = null

    private var deadLetterExchange: Output<String>? = null

    private var deadLetterRoutingKey: Output<String>? = null

    private var exclusiveState: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var maxLength: Output<String>? = null

    private var maximumPriority: Output<Int>? = null

    private var messageTtl: Output<String>? = null

    private var queueName: Output<String>? = null

    private var virtualHostName: Output<String>? = null

    /**
     * @param value Specifies whether the Auto Delete attribute is configured. Valid values:
     * * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
     * * false: The Auto Delete attribute is not configured.
     */
    @JvmName("gnvvaqixvxuovmkh")
    public suspend fun autoDeleteState(`value`: Output<Boolean>) {
        this.autoDeleteState = value
    }

    /**
     * @param value The validity period after which the queue is automatically deleted.
     * If the queue is not accessed within a specified period of time, it is automatically deleted.
     */
    @JvmName("feuspcvbicslmvik")
    public suspend fun autoExpireState(`value`: Output<String>) {
        this.autoExpireState = value
    }

    /**
     * @param value The dead-letter exchange. A dead-letter exchange is used to receive rejected messages.
     * If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
     * Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
     */
    @JvmName("hpydpltvnhjyojho")
    public suspend fun deadLetterExchange(`value`: Output<String>) {
        this.deadLetterExchange = value
    }

    /**
     * @param value The dead letter routing key.
     */
    @JvmName("npleyrkfxnosduyh")
    public suspend fun deadLetterRoutingKey(`value`: Output<String>) {
        this.deadLetterRoutingKey = value
    }

    /**
     * @param value Specifies whether the queue is an exclusive queue. Valid values:
     * * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
     * * false: The queue is not an exclusive queue.
     */
    @JvmName("kfardtwnmyssqmgk")
    public suspend fun exclusiveState(`value`: Output<Boolean>) {
        this.exclusiveState = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("lcrstlpuricobjcx")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The maximum number of messages that can be stored in the queue.
     * If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
     */
    @JvmName("wgcehrqmlnhsntlu")
    public suspend fun maxLength(`value`: Output<String>) {
        this.maxLength = value
    }

    /**
     * @param value The highest priority supported by the queue. This parameter is set to a positive integer.
     * Valid values: 0 to 255. Recommended values: 1 to 10
     */
    @JvmName("aksrquvgnttcyweq")
    public suspend fun maximumPriority(`value`: Output<Int>) {
        this.maximumPriority = value
    }

    /**
     * @param value The message TTL of the queue.
     * If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
     * Message TTL must be set to a non-negative integer, in milliseconds.
     * For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
     */
    @JvmName("mstwsujnstlmykcg")
    public suspend fun messageTtl(`value`: Output<String>) {
        this.messageTtl = value
    }

    /**
     * @param value The name of the queue.
     * The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     */
    @JvmName("ddvbgdhlhnbxqaah")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value The name of the virtual host.
     */
    @JvmName("mqchsnalowkkbbbu")
    public suspend fun virtualHostName(`value`: Output<String>) {
        this.virtualHostName = value
    }

    /**
     * @param value Specifies whether the Auto Delete attribute is configured. Valid values:
     * * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
     * * false: The Auto Delete attribute is not configured.
     */
    @JvmName("tcrnlwilywbbtegu")
    public suspend fun autoDeleteState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteState = mapped
    }

    /**
     * @param value The validity period after which the queue is automatically deleted.
     * If the queue is not accessed within a specified period of time, it is automatically deleted.
     */
    @JvmName("imhdytimfehlyjis")
    public suspend fun autoExpireState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoExpireState = mapped
    }

    /**
     * @param value The dead-letter exchange. A dead-letter exchange is used to receive rejected messages.
     * If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
     * Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
     */
    @JvmName("oantbpkqhxumtcej")
    public suspend fun deadLetterExchange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterExchange = mapped
    }

    /**
     * @param value The dead letter routing key.
     */
    @JvmName("psjyjypasxwlnvyq")
    public suspend fun deadLetterRoutingKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterRoutingKey = mapped
    }

    /**
     * @param value Specifies whether the queue is an exclusive queue. Valid values:
     * * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
     * * false: The queue is not an exclusive queue.
     */
    @JvmName("bjjjwtwesoeyjolo")
    public suspend fun exclusiveState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusiveState = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("cgjryipkkelpafic")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The maximum number of messages that can be stored in the queue.
     * If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
     */
    @JvmName("evlwolyrspjwyhpu")
    public suspend fun maxLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxLength = mapped
    }

    /**
     * @param value The highest priority supported by the queue. This parameter is set to a positive integer.
     * Valid values: 0 to 255. Recommended values: 1 to 10
     */
    @JvmName("orbdhgmopuccdsdd")
    public suspend fun maximumPriority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumPriority = mapped
    }

    /**
     * @param value The message TTL of the queue.
     * If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
     * Message TTL must be set to a non-negative integer, in milliseconds.
     * For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
     */
    @JvmName("wcjbrbgxlxhefvrs")
    public suspend fun messageTtl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageTtl = mapped
    }

    /**
     * @param value The name of the queue.
     * The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
     */
    @JvmName("yvgmcfsraaccjstd")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value The name of the virtual host.
     */
    @JvmName("utohcdxmytfgddhr")
    public suspend fun virtualHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHostName = mapped
    }

    internal fun build(): QueueArgs = QueueArgs(
        autoDeleteState = autoDeleteState,
        autoExpireState = autoExpireState,
        deadLetterExchange = deadLetterExchange,
        deadLetterRoutingKey = deadLetterRoutingKey,
        exclusiveState = exclusiveState,
        instanceId = instanceId,
        maxLength = maxLength,
        maximumPriority = maximumPriority,
        messageTtl = messageTtl,
        queueName = queueName,
        virtualHostName = virtualHostName,
    )
}
