@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticAccount].
 */
@PulumiTagMarker
public class StaticAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticAccountArgs = StaticAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticAccountArgsBuilder.() -> Unit) {
        val builder = StaticAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StaticAccount {
        val builtJavaResource = com.pulumi.alicloud.amqp.StaticAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StaticAccount(builtJavaResource)
    }
}

/**
 * Provides a Amqp Static Account resource.
 * For information about Amqp Static Account and how to use it, see [What is Static Account](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/create-a-pair-of-static-username-and-password).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const accessKey = config.get("accessKey") || "access_key";
 * const secretKey = config.get("secretKey") || "secret_key";
 * const _default = new alicloud.amqp.Instance("default", {
 *     instanceType: "enterprise",
 *     maxTps: "3000",
 *     queueCapacity: "200",
 *     storageSize: "700",
 *     supportEip: false,
 *     maxEipTps: "128",
 *     paymentType: "Subscription",
 *     period: 1,
 * });
 * const defaultStaticAccount = new alicloud.amqp.StaticAccount("default", {
 *     instanceId: _default.id,
 *     accessKey: accessKey,
 *     secretKey: secretKey,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * access_key = config.get("accessKey")
 * if access_key is None:
 *     access_key = "access_key"
 * secret_key = config.get("secretKey")
 * if secret_key is None:
 *     secret_key = "secret_key"
 * default = alicloud.amqp.Instance("default",
 *     instance_type="enterprise",
 *     max_tps="3000",
 *     queue_capacity="200",
 *     storage_size="700",
 *     support_eip=False,
 *     max_eip_tps="128",
 *     payment_type="Subscription",
 *     period=1)
 * default_static_account = alicloud.amqp.StaticAccount("default",
 *     instance_id=default.id,
 *     access_key=access_key,
 *     secret_key=secret_key)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var accessKey = config.Get("accessKey") ?? "access_key";
 *     var secretKey = config.Get("secretKey") ?? "secret_key";
 *     var @default = new AliCloud.Amqp.Instance("default", new()
 *     {
 *         InstanceType = "enterprise",
 *         MaxTps = "3000",
 *         QueueCapacity = "200",
 *         StorageSize = "700",
 *         SupportEip = false,
 *         MaxEipTps = "128",
 *         PaymentType = "Subscription",
 *         Period = 1,
 *     });
 *     var defaultStaticAccount = new AliCloud.Amqp.StaticAccount("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         AccessKey = accessKey,
 *         SecretKey = secretKey,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		accessKey := "access_key"
 * 		if param := cfg.Get("accessKey"); param != "" {
 * 			accessKey = param
 * 		}
 * 		secretKey := "secret_key"
 * 		if param := cfg.Get("secretKey"); param != "" {
 * 			secretKey = param
 * 		}
 * 		_, err := amqp.NewInstance(ctx, "default", &amqp.InstanceArgs{
 * 			InstanceType:  pulumi.String("enterprise"),
 * 			MaxTps:        pulumi.String("3000"),
 * 			QueueCapacity: pulumi.String("200"),
 * 			StorageSize:   pulumi.String("700"),
 * 			SupportEip:    pulumi.Bool(false),
 * 			MaxEipTps:     pulumi.String("128"),
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewStaticAccount(ctx, "default", &amqp.StaticAccountArgs{
 * 			InstanceId: _default.ID(),
 * 			AccessKey:  pulumi.String(accessKey),
 * 			SecretKey:  pulumi.String(secretKey),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.amqp.Instance;
 * import com.pulumi.alicloud.amqp.InstanceArgs;
 * import com.pulumi.alicloud.amqp.StaticAccount;
 * import com.pulumi.alicloud.amqp.StaticAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var accessKey = config.get("accessKey").orElse("access_key");
 *         final var secretKey = config.get("secretKey").orElse("secret_key");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceType("enterprise")
 *             .maxTps(3000)
 *             .queueCapacity(200)
 *             .storageSize(700)
 *             .supportEip(false)
 *             .maxEipTps(128)
 *             .paymentType("Subscription")
 *             .period(1)
 *             .build());
 *         var defaultStaticAccount = new StaticAccount("defaultStaticAccount", StaticAccountArgs.builder()
 *             .instanceId(default_.id())
 *             .accessKey(accessKey)
 *             .secretKey(secretKey)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   accessKey:
 *     type: string
 *     default: access_key
 *   secretKey:
 *     type: string
 *     default: secret_key
 * resources:
 *   default:
 *     type: alicloud:amqp:Instance
 *     properties:
 *       instanceType: enterprise
 *       maxTps: 3000
 *       queueCapacity: 200
 *       storageSize: 700
 *       supportEip: false
 *       maxEipTps: 128
 *       paymentType: Subscription
 *       period: 1
 *   defaultStaticAccount:
 *     type: alicloud:amqp:StaticAccount
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       accessKey: ${accessKey}
 *       secretKey: ${secretKey}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Amqp Static Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/staticAccount:StaticAccount example <instance_id>:<access_key>
 * ```
 */
public class StaticAccount internal constructor(
    override val javaResource: com.pulumi.alicloud.amqp.StaticAccount,
) : KotlinCustomResource(javaResource, StaticAccountMapper) {
    /**
     * Access key.
     */
    public val accessKey: Output<String>
        get() = javaResource.accessKey().applyValue({ args0 -> args0 })

    /**
     * Create time stamp. Unix timestamp, to millisecond level.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Amqp instance ID.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the user's primary account.
     */
    public val masterUid: Output<String>
        get() = javaResource.masterUid().applyValue({ args0 -> args0 })

    /**
     * Static password.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * Secret key.
     */
    public val secretKey: Output<String>
        get() = javaResource.secretKey().applyValue({ args0 -> args0 })

    /**
     * Static user name.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object StaticAccountMapper : ResourceMapper<StaticAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.amqp.StaticAccount::class == javaResource::class

    override fun map(javaResource: Resource): StaticAccount = StaticAccount(
        javaResource as
            com.pulumi.alicloud.amqp.StaticAccount,
    )
}

/**
 * @see [StaticAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticAccount].
 */
public suspend fun staticAccount(
    name: String,
    block: suspend StaticAccountResourceBuilder.() -> Unit,
): StaticAccount {
    val builder = StaticAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticAccount(name: String): StaticAccount {
    val builder = StaticAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
