@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualHost].
 */
@PulumiTagMarker
public class VirtualHostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualHostArgs = VirtualHostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualHostArgsBuilder.() -> Unit) {
        val builder = VirtualHostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualHost {
        val builtJavaResource = com.pulumi.alicloud.amqp.VirtualHost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualHost(builtJavaResource)
    }
}

/**
 * Provides a RabbitMQ (AMQP) Virtual Host resource.
 * For information about RabbitMQ (AMQP) Virtual Host and how to use it, see [What is Virtual Host](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createvirtualhost).
 * > **NOTE:** Available since v1.126.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.amqp.Instance("default", {
 *     instanceType: "professional",
 *     maxTps: "1000",
 *     queueCapacity: "50",
 *     supportEip: true,
 *     maxEipTps: "128",
 *     paymentType: "Subscription",
 *     period: 1,
 * });
 * const defaultVirtualHost = new alicloud.amqp.VirtualHost("default", {
 *     instanceId: _default.id,
 *     virtualHostName: "tf-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.amqp.Instance("default",
 *     instance_type="professional",
 *     max_tps="1000",
 *     queue_capacity="50",
 *     support_eip=True,
 *     max_eip_tps="128",
 *     payment_type="Subscription",
 *     period=1)
 * default_virtual_host = alicloud.amqp.VirtualHost("default",
 *     instance_id=default.id,
 *     virtual_host_name="tf-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Amqp.Instance("default", new()
 *     {
 *         InstanceType = "professional",
 *         MaxTps = "1000",
 *         QueueCapacity = "50",
 *         SupportEip = true,
 *         MaxEipTps = "128",
 *         PaymentType = "Subscription",
 *         Period = 1,
 *     });
 *     var defaultVirtualHost = new AliCloud.Amqp.VirtualHost("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         VirtualHostName = "tf-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/amqp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amqp.NewInstance(ctx, "default", &amqp.InstanceArgs{
 * 			InstanceType:  pulumi.String("professional"),
 * 			MaxTps:        pulumi.String("1000"),
 * 			QueueCapacity: pulumi.String("50"),
 * 			SupportEip:    pulumi.Bool(true),
 * 			MaxEipTps:     pulumi.String("128"),
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amqp.NewVirtualHost(ctx, "default", &amqp.VirtualHostArgs{
 * 			InstanceId:      _default.ID(),
 * 			VirtualHostName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.amqp.Instance;
 * import com.pulumi.alicloud.amqp.InstanceArgs;
 * import com.pulumi.alicloud.amqp.VirtualHost;
 * import com.pulumi.alicloud.amqp.VirtualHostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceType("professional")
 *             .maxTps(1000)
 *             .queueCapacity(50)
 *             .supportEip(true)
 *             .maxEipTps(128)
 *             .paymentType("Subscription")
 *             .period(1)
 *             .build());
 *         var defaultVirtualHost = new VirtualHost("defaultVirtualHost", VirtualHostArgs.builder()
 *             .instanceId(default_.id())
 *             .virtualHostName("tf-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:amqp:Instance
 *     properties:
 *       instanceType: professional
 *       maxTps: 1000
 *       queueCapacity: 50
 *       supportEip: true
 *       maxEipTps: 128
 *       paymentType: Subscription
 *       period: 1
 *   defaultVirtualHost:
 *     type: alicloud:amqp:VirtualHost
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       virtualHostName: tf-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RabbitMQ (AMQP) Virtual Host can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:amqp/virtualHost:VirtualHost example <instance_id>:<virtual_host_name>
 * ```
 */
public class VirtualHost internal constructor(
    override val javaResource: com.pulumi.alicloud.amqp.VirtualHost,
) : KotlinCustomResource(javaResource, VirtualHostMapper) {
    /**
     * InstanceId.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * VirtualHostName.
     */
    public val virtualHostName: Output<String>
        get() = javaResource.virtualHostName().applyValue({ args0 -> args0 })
}

public object VirtualHostMapper : ResourceMapper<VirtualHost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.amqp.VirtualHost::class == javaResource::class

    override fun map(javaResource: Resource): VirtualHost = VirtualHost(
        javaResource as
            com.pulumi.alicloud.amqp.VirtualHost,
    )
}

/**
 * @see [VirtualHost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualHost].
 */
public suspend fun virtualHost(name: String, block: suspend VirtualHostResourceBuilder.() -> Unit): VirtualHost {
    val builder = VirtualHostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualHost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualHost(name: String): VirtualHost {
    val builder = VirtualHostResourceBuilder()
    builder.name(name)
    return builder.build()
}
