@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.inputs

import com.pulumi.alicloud.amqp.inputs.GetBindingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBindings.
 * @property instanceId Instance Id.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property virtualHostName Virtualhost Name.
 */
public data class GetBindingsPlainArgs(
    public val instanceId: String,
    public val outputFile: String? = null,
    public val virtualHostName: String,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.inputs.GetBindingsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.inputs.GetBindingsPlainArgs =
        com.pulumi.alicloud.amqp.inputs.GetBindingsPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .virtualHostName(virtualHostName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBindingsPlainArgs].
 */
@PulumiTagMarker
public class GetBindingsPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var outputFile: String? = null

    private var virtualHostName: String? = null

    /**
     * @param value Instance Id.
     */
    @JvmName("phxlglaseagkcsbc")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hehgqggigqnsdykc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Virtualhost Name.
     */
    @JvmName("ettaosvfywixkfee")
    public suspend fun virtualHostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHostName = mapped
    }

    internal fun build(): GetBindingsPlainArgs = GetBindingsPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
        virtualHostName = virtualHostName ?: throw PulumiNullFieldException("virtualHostName"),
    )
}
