@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.inputs

import com.pulumi.alicloud.amqp.inputs.GetExchangesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExchanges.
 * @property ids A list of Exchange IDs. Its element value is same as Exchange Name.
 * @property instanceId The ID of the instance.
 * @property nameRegex A regex string to filter results by Exchange name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property virtualHostName The name of virtual host where an exchange resides.
 */
public data class GetExchangesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val virtualHostName: String,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.inputs.GetExchangesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.inputs.GetExchangesPlainArgs =
        com.pulumi.alicloud.amqp.inputs.GetExchangesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .virtualHostName(virtualHostName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExchangesPlainArgs].
 */
@PulumiTagMarker
public class GetExchangesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var virtualHostName: String? = null

    /**
     * @param value A list of Exchange IDs. Its element value is same as Exchange Name.
     */
    @JvmName("uokdibxqygyqmfvw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Exchange IDs. Its element value is same as Exchange Name.
     */
    @JvmName("rsbisjfeblulochs")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("jesbcxyidtnbwucl")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Exchange name.
     */
    @JvmName("xkfmhercglutfikb")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vjtrsdsvtyjbgbar")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of virtual host where an exchange resides.
     */
    @JvmName("edumwxvvdsdoaglw")
    public suspend fun virtualHostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHostName = mapped
    }

    internal fun build(): GetExchangesPlainArgs = GetExchangesPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        virtualHostName = virtualHostName ?: throw PulumiNullFieldException("virtualHostName"),
    )
}
