@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.inputs

import com.pulumi.alicloud.amqp.inputs.GetQueuesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQueues.
 * @property ids A list of Queue IDs. Its element value is same as Queue Name.
 * @property instanceId The ID of the instance.
 * @property nameRegex A regex string to filter results by Queue name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property virtualHostName The name of the virtual host.
 */
public data class GetQueuesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val virtualHostName: String,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.inputs.GetQueuesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.inputs.GetQueuesPlainArgs =
        com.pulumi.alicloud.amqp.inputs.GetQueuesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .virtualHostName(virtualHostName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQueuesPlainArgs].
 */
@PulumiTagMarker
public class GetQueuesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var virtualHostName: String? = null

    /**
     * @param value A list of Queue IDs. Its element value is same as Queue Name.
     */
    @JvmName("uconrqdnedxrltog")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Queue IDs. Its element value is same as Queue Name.
     */
    @JvmName("wgpcnbxdydnfeexm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("sbakiepreecrlwfw")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Queue name.
     */
    @JvmName("efeggvvgnyaeiuqg")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sxvptihgrrnskmkl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the virtual host.
     */
    @JvmName("xltmgscwmqfufjdx")
    public suspend fun virtualHostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHostName = mapped
    }

    internal fun build(): GetQueuesPlainArgs = GetQueuesPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        virtualHostName = virtualHostName ?: throw PulumiNullFieldException("virtualHostName"),
    )
}
