@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.inputs

import com.pulumi.alicloud.amqp.inputs.GetStaticAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStaticAccounts.
 * @property ids The `key` of the resource supplied above.The value is formulated as `<instance_id>:<access_key>`.
 * @property instanceId InstanceId
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetStaticAccountsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.inputs.GetStaticAccountsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.inputs.GetStaticAccountsPlainArgs =
        com.pulumi.alicloud.amqp.inputs.GetStaticAccountsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetStaticAccountsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The `key` of the resource supplied above.The value is formulated as `<instance_id>:<access_key>`.
     */
    @JvmName("nehowahngrjmtqkh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values The `key` of the resource supplied above.The value is formulated as `<instance_id>:<access_key>`.
     */
    @JvmName("dcdhebdveqiyvuxe")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value InstanceId
     */
    @JvmName("ejvsbikmoerxgiwy")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lqoqvqiughxlmtph")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetStaticAccountsPlainArgs = GetStaticAccountsPlainArgs(
        ids = ids,
        instanceId = instanceId,
        outputFile = outputFile,
    )
}
