@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.inputs

import com.pulumi.alicloud.amqp.inputs.GetVirtualHostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVirtualHosts.
 * @property ids A list of Virtual Host IDs. Its element value is same as Virtual Host Name.
 * @property instanceId InstanceId.
 * @property nameRegex A regex string to filter results by Virtual Host name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetVirtualHostsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.amqp.inputs.GetVirtualHostsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.amqp.inputs.GetVirtualHostsPlainArgs =
        com.pulumi.alicloud.amqp.inputs.GetVirtualHostsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualHostsPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualHostsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Virtual Host IDs. Its element value is same as Virtual Host Name.
     */
    @JvmName("fhcoyrafhomyirad")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Virtual Host IDs. Its element value is same as Virtual Host Name.
     */
    @JvmName("viyefspoiwwpwjxt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value InstanceId.
     */
    @JvmName("jiogtqpgabsbsfep")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Virtual Host name.
     */
    @JvmName("nhshlmffbirkueop")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rsiobmemliswksru")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetVirtualHostsPlainArgs = GetVirtualHostsPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
