@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property argument X-match Attributes. Valid Values: All: Default Value, All the Message Header of Key-Value Pairs Stored in the Must Match. Any: at Least One Pair of the Message Header of Key-Value Pairs Stored in the Must Match. This Parameter Applies Only to Headers Exchange Other Types of Exchange Is Invalid. Other Types of Exchange Here Can Either Be an Arbitrary Value.
 * @property bindingKey The Binding Key. The Source of the Binding Exchange Non-Topic Type: Can Only Contain Letters, Lowercase Letters, Numbers, and the Dash (-), the Underscore Character (_), English Periods (.) and the at Sign (@). Length from 1 to 255 Characters. The Source of the Binding Exchange Topic Type: Can Contain Letters, Lowercase Letters, Numbers, and the Dash (-), the Underscore Character (_), English Periods (.) and the at Sign (@). If You Include the Hash (.
 * @property bindingType The Target Binding Types.
 * @property destinationName The Target Queue Or Exchange of the Name.
 * @property id The ID of the Binding. The value formats as `<instance_id>:<virtual_host_name>:<source_exchange>:<destination_name>`.
 * @property instanceId Instance Id.
 * @property sourceExchange The Source Exchange Name.
 * @property virtualHostName Virtualhost Name.
 */
public data class GetBindingsBinding(
    public val argument: String,
    public val bindingKey: String,
    public val bindingType: String,
    public val destinationName: String,
    public val id: String,
    public val instanceId: String,
    public val sourceExchange: String,
    public val virtualHostName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetBindingsBinding): GetBindingsBinding = GetBindingsBinding(
            argument = javaType.argument(),
            bindingKey = javaType.bindingKey(),
            bindingType = javaType.bindingType(),
            destinationName = javaType.destinationName(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            sourceExchange = javaType.sourceExchange(),
            virtualHostName = javaType.virtualHostName(),
        )
    }
}
