@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBindings.
 * @property bindings
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property outputFile
 * @property virtualHostName
 */
public data class GetBindingsResult(
    public val bindings: List<GetBindingsBinding>,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val virtualHostName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetBindingsResult): GetBindingsResult = GetBindingsResult(
            bindings = javaType.bindings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.amqp.kotlin.outputs.GetBindingsBinding.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            virtualHostName = javaType.virtualHostName(),
        )
    }
}
