@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property attributes The attributes.
 * @property autoDeleteState Indicates whether the Auto Delete attribute is configured.
 * @property createTime The creation time.
 * @property exchangeName The name of the exchange.
 * @property exchangeType The type of the exchange.
 * @property id The ID of the Exchange. Its value is same as Queue Name.
 * @property instanceId The ID of the instance.
 * @property virtualHostName The name of virtual host where an exchange resides.
 */
public data class GetExchangesExchange(
    public val attributes: Map<String, String>,
    public val autoDeleteState: Boolean,
    public val createTime: String,
    public val exchangeName: String,
    public val exchangeType: String,
    public val id: String,
    public val instanceId: String,
    public val virtualHostName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetExchangesExchange): GetExchangesExchange = GetExchangesExchange(
            attributes = javaType.attributes().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            autoDeleteState = javaType.autoDeleteState(),
            createTime = javaType.createTime(),
            exchangeName = javaType.exchangeName(),
            exchangeType = javaType.exchangeType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            virtualHostName = javaType.virtualHostName(),
        )
    }
}
