@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getExchanges.
 * @property exchanges
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property virtualHostName
 */
public data class GetExchangesResult(
    public val exchanges: List<GetExchangesExchange>,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val virtualHostName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetExchangesResult): GetExchangesResult = GetExchangesResult(
            exchanges = javaType.exchanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.amqp.kotlin.outputs.GetExchangesExchange.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            virtualHostName = javaType.virtualHostName(),
        )
    }
}
