@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime OrderCreateTime.
 * @property expireTime ExpireTime.
 * @property id The ID of the Instance.
 * @property instanceId THe instance Id.
 * @property instanceName THe instance name.
 * @property instanceType The instance type.
 * @property paymentType The Pay-as-You-Type Values Include: the Subscription of a Pre-Paid.
 * @property privateEndPoint The private endPoint.
 * @property publicEndpoint The public dndpoint.
 * @property renewalDuration Renewal duration.
 * @property renewalDurationUnit Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
 * @property renewalStatus Renew status.
 * @property status The status of the resource.
 * @property supportEip Whether to support eip.
 */
public data class GetInstancesInstance(
    public val createTime: String,
    public val expireTime: String,
    public val id: String,
    public val instanceId: String,
    public val instanceName: String,
    public val instanceType: String,
    public val paymentType: String,
    public val privateEndPoint: String,
    public val publicEndpoint: String,
    public val renewalDuration: Int,
    public val renewalDurationUnit: String,
    public val renewalStatus: String,
    public val status: String,
    public val supportEip: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            createTime = javaType.createTime(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            instanceType = javaType.instanceType(),
            paymentType = javaType.paymentType(),
            privateEndPoint = javaType.privateEndPoint(),
            publicEndpoint = javaType.publicEndpoint(),
            renewalDuration = javaType.renewalDuration(),
            renewalDurationUnit = javaType.renewalDurationUnit(),
            renewalStatus = javaType.renewalStatus(),
            status = javaType.status(),
            supportEip = javaType.supportEip(),
        )
    }
}
