@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property attributes The attributes for the Queue.
 * @property autoDeleteState Specifies whether the Auto Delete attribute is configured.
 * @property createTime CreateTime.
 * @property exclusiveState Specifies whether the queue is an exclusive queue.
 * @property id The ID of the Queue. Its value is same as Queue Name.
 * @property instanceId The ID of the instance.
 * @property lastConsumeTime The last consume time.
 * @property queueName The queue name.
 * @property virtualHostName The name of the virtual host.
 */
public data class GetQueuesQueue(
    public val attributes: Map<String, String>,
    public val autoDeleteState: Boolean,
    public val createTime: String,
    public val exclusiveState: Boolean,
    public val id: String,
    public val instanceId: String,
    public val lastConsumeTime: String,
    public val queueName: String,
    public val virtualHostName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetQueuesQueue): GetQueuesQueue =
            GetQueuesQueue(
                attributes = javaType.attributes().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                autoDeleteState = javaType.autoDeleteState(),
                createTime = javaType.createTime(),
                exclusiveState = javaType.exclusiveState(),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                lastConsumeTime = javaType.lastConsumeTime(),
                queueName = javaType.queueName(),
                virtualHostName = javaType.virtualHostName(),
            )
    }
}
