@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessKey Access key.
 * @property createTime Create time stamp. Unix timestamp, to millisecond level.
 * @property id The `key` of the resource supplied above.The value is formulated as `<instance_id>:<access_key>`.
 * @property instanceId InstanceId
 * @property masterUid The ID of the user's primary account.
 * @property password Static password.
 * @property userName Static username.
 */
public data class GetStaticAccountsAccount(
    public val accessKey: String,
    public val createTime: String,
    public val id: String,
    public val instanceId: String,
    public val masterUid: String,
    public val password: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetStaticAccountsAccount): GetStaticAccountsAccount = GetStaticAccountsAccount(
            accessKey = javaType.accessKey(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            masterUid = javaType.masterUid(),
            password = javaType.password(),
            userName = javaType.userName(),
        )
    }
}
