@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.amqp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getStaticAccounts.
 * @property accounts A list of Static Account Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId Amqp instance ID.
 * @property outputFile
 */
public data class GetStaticAccountsResult(
    public val accounts: List<GetStaticAccountsAccount>,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.amqp.outputs.GetStaticAccountsResult): GetStaticAccountsResult = GetStaticAccountsResult(
            accounts = javaType.accounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.amqp.kotlin.outputs.GetStaticAccountsAccount.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
