@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.kotlin.outputs.AccessControlListAclEntry
import com.pulumi.alicloud.apigateway.kotlin.outputs.AccessControlListAclEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AccessControlList].
 */
@PulumiTagMarker
public class AccessControlListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessControlListArgs = AccessControlListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessControlListArgsBuilder.() -> Unit) {
        val builder = AccessControlListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessControlList {
        val builtJavaResource =
            com.pulumi.alicloud.apigateway.AccessControlList(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessControlList(builtJavaResource)
    }
}

/**
 * Provides a Api Gateway Access Control List resource. Access control list.
 * For information about Api Gateway Access Control List and how to use it, see [What is Access Control List](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createaccesscontrollist).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const defaultxywS8c = new alicloud.apigateway.Instance("defaultxywS8c", {
 *     instanceName: name,
 *     instanceSpec: "api.s1.small",
 *     httpsPolicy: "HTTPS2_TLS1_0",
 *     zoneId: "cn-hangzhou-MAZ6",
 *     paymentType: "PayAsYouGo",
 * });
 * const _default = new alicloud.apigateway.AccessControlList("default", {
 *     accessControlListName: name,
 *     addressIpVersion: "ipv4",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * defaultxyw_s8c = alicloud.apigateway.Instance("defaultxywS8c",
 *     instance_name=name,
 *     instance_spec="api.s1.small",
 *     https_policy="HTTPS2_TLS1_0",
 *     zone_id="cn-hangzhou-MAZ6",
 *     payment_type="PayAsYouGo")
 * default = alicloud.apigateway.AccessControlList("default",
 *     access_control_list_name=name,
 *     address_ip_version="ipv4")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var defaultxywS8c = new AliCloud.ApiGateway.Instance("defaultxywS8c", new()
 *     {
 *         InstanceName = name,
 *         InstanceSpec = "api.s1.small",
 *         HttpsPolicy = "HTTPS2_TLS1_0",
 *         ZoneId = "cn-hangzhou-MAZ6",
 *         PaymentType = "PayAsYouGo",
 *     });
 *     var @default = new AliCloud.ApiGateway.AccessControlList("default", new()
 *     {
 *         AccessControlListName = name,
 *         AddressIpVersion = "ipv4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := apigateway.NewInstance(ctx, "defaultxywS8c", &apigateway.InstanceArgs{
 * 			InstanceName: pulumi.String(name),
 * 			InstanceSpec: pulumi.String("api.s1.small"),
 * 			HttpsPolicy:  pulumi.String("HTTPS2_TLS1_0"),
 * 			ZoneId:       pulumi.String("cn-hangzhou-MAZ6"),
 * 			PaymentType:  pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewAccessControlList(ctx, "default", &apigateway.AccessControlListArgs{
 * 			AccessControlListName: pulumi.String(name),
 * 			AddressIpVersion:      pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Instance;
 * import com.pulumi.alicloud.apigateway.InstanceArgs;
 * import com.pulumi.alicloud.apigateway.AccessControlList;
 * import com.pulumi.alicloud.apigateway.AccessControlListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var defaultxywS8c = new Instance("defaultxywS8c", InstanceArgs.builder()
 *             .instanceName(name)
 *             .instanceSpec("api.s1.small")
 *             .httpsPolicy("HTTPS2_TLS1_0")
 *             .zoneId("cn-hangzhou-MAZ6")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *         var default_ = new AccessControlList("default", AccessControlListArgs.builder()
 *             .accessControlListName(name)
 *             .addressIpVersion("ipv4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   defaultxywS8c:
 *     type: alicloud:apigateway:Instance
 *     properties:
 *       instanceName: ${name}
 *       instanceSpec: api.s1.small
 *       httpsPolicy: HTTPS2_TLS1_0
 *       zoneId: cn-hangzhou-MAZ6
 *       paymentType: PayAsYouGo
 *   default:
 *     type: alicloud:apigateway:AccessControlList
 *     properties:
 *       accessControlListName: ${name}
 *       addressIpVersion: ipv4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Access Control List can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/accessControlList:AccessControlList example <id>
 * ```
 */
public class AccessControlList internal constructor(
    override val javaResource: com.pulumi.alicloud.apigateway.AccessControlList,
) : KotlinCustomResource(javaResource, AccessControlListMapper) {
    /**
     * Access control list name.
     */
    public val accessControlListName: Output<String>
        get() = javaResource.accessControlListName().applyValue({ args0 -> args0 })

    /**
     * Information list of access control policies. You can add at most 50 IP addresses or CIDR blocks to an ACL in each call. If the IP address or CIDR block that you want to add to an ACL already exists, the IP address or CIDR block is not added. The entries that you add must be CIDR blocks. See `acl_entrys` below.
     * **NOTE:** Field 'acl_entrys' has been deprecated from provider version 1.228.0, and it will be removed in the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
     */
    @Deprecated(
        message = """
  Field 'acl_entrys' has been deprecated from provider version v1.228.0, and it will be removed in
      the future version. Please use the new resource 'alicloud_api_gateway_acl_entry_attachment'.
  """,
    )
    public val aclEntrys: Output<List<AccessControlListAclEntry>>
        get() = javaResource.aclEntrys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The IP version. Valid values: ipv4 and ipv6.
     */
    public val addressIpVersion: Output<String>
        get() = javaResource.addressIpVersion().applyValue({ args0 -> args0 })
}

public object AccessControlListMapper : ResourceMapper<AccessControlList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.apigateway.AccessControlList::class == javaResource::class

    override fun map(javaResource: Resource): AccessControlList = AccessControlList(
        javaResource as
            com.pulumi.alicloud.apigateway.AccessControlList,
    )
}

/**
 * @see [AccessControlList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessControlList].
 */
public suspend fun accessControlList(
    name: String,
    block: suspend AccessControlListResourceBuilder.() -> Unit,
): AccessControlList {
    val builder = AccessControlListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessControlList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessControlList(name: String): AccessControlList {
    val builder = AccessControlListResourceBuilder()
    builder.name(name)
    return builder.build()
}
