@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.AclEntryAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an ACL entry attachment resource for attaching ACL entry to an API Gateway ACL.
 * > **NOTE:** Available since v1.228.0
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.apigateway.AccessControlList("default", {
 *     accessControlListName: name,
 *     addressIpVersion: "ipv4",
 * });
 * const defaultAclEntryAttachment = new alicloud.apigateway.AclEntryAttachment("default", {
 *     aclId: _default.id,
 *     entry: "128.0.0.1/32",
 *     comment: "test comment",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.apigateway.AccessControlList("default",
 *     access_control_list_name=name,
 *     address_ip_version="ipv4")
 * default_acl_entry_attachment = alicloud.apigateway.AclEntryAttachment("default",
 *     acl_id=default.id,
 *     entry="128.0.0.1/32",
 *     comment="test comment")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.ApiGateway.AccessControlList("default", new()
 *     {
 *         AccessControlListName = name,
 *         AddressIpVersion = "ipv4",
 *     });
 *     var defaultAclEntryAttachment = new AliCloud.ApiGateway.AclEntryAttachment("default", new()
 *     {
 *         AclId = @default.Id,
 *         Entry = "128.0.0.1/32",
 *         Comment = "test comment",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := apigateway.NewAccessControlList(ctx, "default", &apigateway.AccessControlListArgs{
 * 			AccessControlListName: pulumi.String(name),
 * 			AddressIpVersion:      pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewAclEntryAttachment(ctx, "default", &apigateway.AclEntryAttachmentArgs{
 * 			AclId:   _default.ID(),
 * 			Entry:   pulumi.String("128.0.0.1/32"),
 * 			Comment: pulumi.String("test comment"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.AccessControlList;
 * import com.pulumi.alicloud.apigateway.AccessControlListArgs;
 * import com.pulumi.alicloud.apigateway.AclEntryAttachment;
 * import com.pulumi.alicloud.apigateway.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new AccessControlList("default", AccessControlListArgs.builder()
 *             .accessControlListName(name)
 *             .addressIpVersion("ipv4")
 *             .build());
 *         var defaultAclEntryAttachment = new AclEntryAttachment("defaultAclEntryAttachment", AclEntryAttachmentArgs.builder()
 *             .aclId(default_.id())
 *             .entry("128.0.0.1/32")
 *             .comment("test comment")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:apigateway:AccessControlList
 *     properties:
 *       accessControlListName: ${name}
 *       addressIpVersion: ipv4
 *   defaultAclEntryAttachment:
 *     type: alicloud:apigateway:AclEntryAttachment
 *     name: default
 *     properties:
 *       aclId: ${default.id}
 *       entry: 128.0.0.1/32
 *       comment: test comment
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Acl Entry Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/aclEntryAttachment:AclEntryAttachment example <acl_id>:<entry>
 * ```
 * @property aclId The ID of the ACL that the entry will be attached to.
 * @property comment The comment for the entry.
 * @property entry The CIDR block of the entry to attach.
 */
public data class AclEntryAttachmentArgs(
    public val aclId: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val entry: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.AclEntryAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.AclEntryAttachmentArgs =
        com.pulumi.alicloud.apigateway.AclEntryAttachmentArgs.builder()
            .aclId(aclId?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .entry(entry?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AclEntryAttachmentArgs].
 */
@PulumiTagMarker
public class AclEntryAttachmentArgsBuilder internal constructor() {
    private var aclId: Output<String>? = null

    private var comment: Output<String>? = null

    private var entry: Output<String>? = null

    /**
     * @param value The ID of the ACL that the entry will be attached to.
     */
    @JvmName("bxokurpxtetvjkdo")
    public suspend fun aclId(`value`: Output<String>) {
        this.aclId = value
    }

    /**
     * @param value The comment for the entry.
     */
    @JvmName("qxheptdhqsxwlxty")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The CIDR block of the entry to attach.
     */
    @JvmName("mtyfjvucqbfsfnrk")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value The ID of the ACL that the entry will be attached to.
     */
    @JvmName("bdmoivvqduljfysu")
    public suspend fun aclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclId = mapped
    }

    /**
     * @param value The comment for the entry.
     */
    @JvmName("jaxifeqqpmwfgsoh")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The CIDR block of the entry to attach.
     */
    @JvmName("fgosacnowwniaymm")
    public suspend fun entry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    internal fun build(): AclEntryAttachmentArgs = AclEntryAttachmentArgs(
        aclId = aclId,
        comment = comment,
        entry = entry,
    )
}
