@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiConstantParameter
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiFcServiceConfig
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiHttpServiceConfig
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiHttpVpcServiceConfig
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiMockServiceConfig
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiRequestConfig
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiRequestParameter
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiSystemParameter
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiConstantParameter.Companion.toKotlin as apiConstantParameterToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiFcServiceConfig.Companion.toKotlin as apiFcServiceConfigToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiHttpServiceConfig.Companion.toKotlin as apiHttpServiceConfigToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiHttpVpcServiceConfig.Companion.toKotlin as apiHttpVpcServiceConfigToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiMockServiceConfig.Companion.toKotlin as apiMockServiceConfigToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiRequestConfig.Companion.toKotlin as apiRequestConfigToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiRequestParameter.Companion.toKotlin as apiRequestParameterToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.ApiSystemParameter.Companion.toKotlin as apiSystemParameterToKotlin

/**
 * Builder for [Api].
 */
@PulumiTagMarker
public class ApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiArgs = ApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiArgsBuilder.() -> Unit) {
        val builder = ApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Api {
        val builtJavaResource = com.pulumi.alicloud.apigateway.Api(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Api(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.apigateway.Group("example", {
 *     name: "tf-example",
 *     description: "tf-example",
 *     basePath: "/",
 * });
 * const exampleApi = new alicloud.apigateway.Api("example", {
 *     groupId: example.id,
 *     name: "tf-example",
 *     description: "tf-example",
 *     authType: "APP",
 *     forceNonceCheck: false,
 *     requestConfig: {
 *         protocol: "HTTP",
 *         method: "GET",
 *         path: "/example/path",
 *         mode: "MAPPING",
 *     },
 *     serviceType: "HTTP",
 *     httpServiceConfig: {
 *         address: "http://apigateway-backend.alicloudapi.com:8080",
 *         method: "GET",
 *         path: "/web/cloudapi",
 *         timeout: 12,
 *         aoneName: "cloudapi-openapi",
 *     },
 *     requestParameters: [{
 *         name: "example",
 *         type: "STRING",
 *         required: "OPTIONAL",
 *         "in": "QUERY",
 *         inService: "QUERY",
 *         nameService: "exampleservice",
 *     }],
 *     stageNames: [
 *         "RELEASE",
 *         "TEST",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.apigateway.Group("example",
 *     name="tf-example",
 *     description="tf-example",
 *     base_path="/")
 * example_api = alicloud.apigateway.Api("example",
 *     group_id=example.id,
 *     name="tf-example",
 *     description="tf-example",
 *     auth_type="APP",
 *     force_nonce_check=False,
 *     request_config={
 *         "protocol": "HTTP",
 *         "method": "GET",
 *         "path": "/example/path",
 *         "mode": "MAPPING",
 *     },
 *     service_type="HTTP",
 *     http_service_config={
 *         "address": "http://apigateway-backend.alicloudapi.com:8080",
 *         "method": "GET",
 *         "path": "/web/cloudapi",
 *         "timeout": 12,
 *         "aone_name": "cloudapi-openapi",
 *     },
 *     request_parameters=[{
 *         "name": "example",
 *         "type": "STRING",
 *         "required": "OPTIONAL",
 *         "in_": "QUERY",
 *         "in_service": "QUERY",
 *         "name_service": "exampleservice",
 *     }],
 *     stage_names=[
 *         "RELEASE",
 *         "TEST",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.ApiGateway.Group("example", new()
 *     {
 *         Name = "tf-example",
 *         Description = "tf-example",
 *         BasePath = "/",
 *     });
 *     var exampleApi = new AliCloud.ApiGateway.Api("example", new()
 *     {
 *         GroupId = example.Id,
 *         Name = "tf-example",
 *         Description = "tf-example",
 *         AuthType = "APP",
 *         ForceNonceCheck = false,
 *         RequestConfig = new AliCloud.ApiGateway.Inputs.ApiRequestConfigArgs
 *         {
 *             Protocol = "HTTP",
 *             Method = "GET",
 *             Path = "/example/path",
 *             Mode = "MAPPING",
 *         },
 *         ServiceType = "HTTP",
 *         HttpServiceConfig = new AliCloud.ApiGateway.Inputs.ApiHttpServiceConfigArgs
 *         {
 *             Address = "http://apigateway-backend.alicloudapi.com:8080",
 *             Method = "GET",
 *             Path = "/web/cloudapi",
 *             Timeout = 12,
 *             AoneName = "cloudapi-openapi",
 *         },
 *         RequestParameters = new[]
 *         {
 *             new AliCloud.ApiGateway.Inputs.ApiRequestParameterArgs
 *             {
 *                 Name = "example",
 *                 Type = "STRING",
 *                 Required = "OPTIONAL",
 *                 In = "QUERY",
 *                 InService = "QUERY",
 *                 NameService = "exampleservice",
 *             },
 *         },
 *         StageNames = new[]
 *         {
 *             "RELEASE",
 *             "TEST",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apigateway.NewGroup(ctx, "example", &apigateway.GroupArgs{
 * 			Name:        pulumi.String("tf-example"),
 * 			Description: pulumi.String("tf-example"),
 * 			BasePath:    pulumi.String("/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewApi(ctx, "example", &apigateway.ApiArgs{
 * 			GroupId:         example.ID(),
 * 			Name:            pulumi.String("tf-example"),
 * 			Description:     pulumi.String("tf-example"),
 * 			AuthType:        pulumi.String("APP"),
 * 			ForceNonceCheck: pulumi.Bool(false),
 * 			RequestConfig: &apigateway.ApiRequestConfigArgs{
 * 				Protocol: pulumi.String("HTTP"),
 * 				Method:   pulumi.String("GET"),
 * 				Path:     pulumi.String("/example/path"),
 * 				Mode:     pulumi.String("MAPPING"),
 * 			},
 * 			ServiceType: pulumi.String("HTTP"),
 * 			HttpServiceConfig: &apigateway.ApiHttpServiceConfigArgs{
 * 				Address:  pulumi.String("http://apigateway-backend.alicloudapi.com:8080"),
 * 				Method:   pulumi.String("GET"),
 * 				Path:     pulumi.String("/web/cloudapi"),
 * 				Timeout:  pulumi.Int(12),
 * 				AoneName: pulumi.String("cloudapi-openapi"),
 * 			},
 * 			RequestParameters: apigateway.ApiRequestParameterArray{
 * 				&apigateway.ApiRequestParameterArgs{
 * 					Name:        pulumi.String("example"),
 * 					Type:        pulumi.String("STRING"),
 * 					Required:    pulumi.String("OPTIONAL"),
 * 					In:          pulumi.String("QUERY"),
 * 					InService:   pulumi.String("QUERY"),
 * 					NameService: pulumi.String("exampleservice"),
 * 				},
 * 			},
 * 			StageNames: pulumi.StringArray{
 * 				pulumi.String("RELEASE"),
 * 				pulumi.String("TEST"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Group;
 * import com.pulumi.alicloud.apigateway.GroupArgs;
 * import com.pulumi.alicloud.apigateway.Api;
 * import com.pulumi.alicloud.apigateway.ApiArgs;
 * import com.pulumi.alicloud.apigateway.inputs.ApiRequestConfigArgs;
 * import com.pulumi.alicloud.apigateway.inputs.ApiHttpServiceConfigArgs;
 * import com.pulumi.alicloud.apigateway.inputs.ApiRequestParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .name("tf-example")
 *             .description("tf-example")
 *             .basePath("/")
 *             .build());
 *         var exampleApi = new Api("exampleApi", ApiArgs.builder()
 *             .groupId(example.id())
 *             .name("tf-example")
 *             .description("tf-example")
 *             .authType("APP")
 *             .forceNonceCheck(false)
 *             .requestConfig(ApiRequestConfigArgs.builder()
 *                 .protocol("HTTP")
 *                 .method("GET")
 *                 .path("/example/path")
 *                 .mode("MAPPING")
 *                 .build())
 *             .serviceType("HTTP")
 *             .httpServiceConfig(ApiHttpServiceConfigArgs.builder()
 *                 .address("http://apigateway-backend.alicloudapi.com:8080")
 *                 .method("GET")
 *                 .path("/web/cloudapi")
 *                 .timeout(12)
 *                 .aoneName("cloudapi-openapi")
 *                 .build())
 *             .requestParameters(ApiRequestParameterArgs.builder()
 *                 .name("example")
 *                 .type("STRING")
 *                 .required("OPTIONAL")
 *                 .in("QUERY")
 *                 .inService("QUERY")
 *                 .nameService("exampleservice")
 *                 .build())
 *             .stageNames(
 *                 "RELEASE",
 *                 "TEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:apigateway:Group
 *     properties:
 *       name: tf-example
 *       description: tf-example
 *       basePath: /
 *   exampleApi:
 *     type: alicloud:apigateway:Api
 *     name: example
 *     properties:
 *       groupId: ${example.id}
 *       name: tf-example
 *       description: tf-example
 *       authType: APP
 *       forceNonceCheck: false
 *       requestConfig:
 *         protocol: HTTP
 *         method: GET
 *         path: /example/path
 *         mode: MAPPING
 *       serviceType: HTTP
 *       httpServiceConfig:
 *         address: http://apigateway-backend.alicloudapi.com:8080
 *         method: GET
 *         path: /web/cloudapi
 *         timeout: 12
 *         aoneName: cloudapi-openapi
 *       requestParameters:
 *         - name: example
 *           type: STRING
 *           required: OPTIONAL
 *           in: QUERY
 *           inService: QUERY
 *           nameService: exampleservice
 *       stageNames:
 *         - RELEASE
 *         - TEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api gateway api can be imported using the id.Format to `<API Group Id>:<API Id>` e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/api:Api example "ab2351f2ce904edaa8d92a0510832b91:e4f728fca5a94148b023b99a3e5d0b62"
 * ```
 */
public class Api internal constructor(
    override val javaResource: com.pulumi.alicloud.apigateway.Api,
) : KotlinCustomResource(javaResource, ApiMapper) {
    /**
     * The ID of the api of api gateway.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * The authorization Type including APP and ANONYMOUS. Defaults to null.
     */
    public val authType: Output<String>
        get() = javaResource.authType().applyValue({ args0 -> args0 })

    /**
     * constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    public val constantParameters: Output<List<ApiConstantParameter>>?
        get() = javaResource.constantParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        apiConstantParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The description of the api. Defaults to null.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
     */
    public val fcServiceConfig: Output<ApiFcServiceConfig>?
        get() = javaResource.fcServiceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiFcServiceConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Whether to prevent API replay attack. Default value: `false`.
     */
    public val forceNonceCheck: Output<Boolean>
        get() = javaResource.forceNonceCheck().applyValue({ args0 -> args0 })

    /**
     * The api gateway that the api belongs to. Defaults to null.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
     */
    public val httpServiceConfig: Output<ApiHttpServiceConfig>?
        get() = javaResource.httpServiceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiHttpServiceConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
     */
    public val httpVpcServiceConfig: Output<ApiHttpVpcServiceConfig>?
        get() = javaResource.httpVpcServiceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiHttpVpcServiceConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
     */
    public val mockServiceConfig: Output<ApiMockServiceConfig>?
        get() = javaResource.mockServiceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiMockServiceConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the api gateway api. Defaults to null.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Request_config defines how users can send requests to your API. See `request_config` below.
     */
    public val requestConfig: Output<ApiRequestConfig>
        get() = javaResource.requestConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                apiRequestConfigToKotlin(args0)
            })
        })

    /**
     * request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    public val requestParameters: Output<List<ApiRequestParameter>>?
        get() = javaResource.requestParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        apiRequestParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
     */
    public val serviceType: Output<String>
        get() = javaResource.serviceType().applyValue({ args0 -> args0 })

    /**
     * Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
     */
    public val stageNames: Output<List<String>>?
        get() = javaResource.stageNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    public val systemParameters: Output<List<ApiSystemParameter>>?
        get() = javaResource.systemParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        apiSystemParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object ApiMapper : ResourceMapper<Api> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.apigateway.Api::class == javaResource::class

    override fun map(javaResource: Resource): Api = Api(
        javaResource as
            com.pulumi.alicloud.apigateway.Api,
    )
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Api].
 */
public suspend fun api(name: String, block: suspend ApiResourceBuilder.() -> Unit): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 */
public fun api(name: String): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
