@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.ApiArgs.builder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiConstantParameterArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiConstantParameterArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiFcServiceConfigArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiFcServiceConfigArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiHttpServiceConfigArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiHttpServiceConfigArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiHttpVpcServiceConfigArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiHttpVpcServiceConfigArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiMockServiceConfigArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiMockServiceConfigArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiRequestConfigArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiRequestConfigArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiRequestParameterArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiRequestParameterArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiSystemParameterArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.ApiSystemParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.apigateway.Group("example", {
 *     name: "tf-example",
 *     description: "tf-example",
 *     basePath: "/",
 * });
 * const exampleApi = new alicloud.apigateway.Api("example", {
 *     groupId: example.id,
 *     name: "tf-example",
 *     description: "tf-example",
 *     authType: "APP",
 *     forceNonceCheck: false,
 *     requestConfig: {
 *         protocol: "HTTP",
 *         method: "GET",
 *         path: "/example/path",
 *         mode: "MAPPING",
 *     },
 *     serviceType: "HTTP",
 *     httpServiceConfig: {
 *         address: "http://apigateway-backend.alicloudapi.com:8080",
 *         method: "GET",
 *         path: "/web/cloudapi",
 *         timeout: 12,
 *         aoneName: "cloudapi-openapi",
 *     },
 *     requestParameters: [{
 *         name: "example",
 *         type: "STRING",
 *         required: "OPTIONAL",
 *         "in": "QUERY",
 *         inService: "QUERY",
 *         nameService: "exampleservice",
 *     }],
 *     stageNames: [
 *         "RELEASE",
 *         "TEST",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.apigateway.Group("example",
 *     name="tf-example",
 *     description="tf-example",
 *     base_path="/")
 * example_api = alicloud.apigateway.Api("example",
 *     group_id=example.id,
 *     name="tf-example",
 *     description="tf-example",
 *     auth_type="APP",
 *     force_nonce_check=False,
 *     request_config={
 *         "protocol": "HTTP",
 *         "method": "GET",
 *         "path": "/example/path",
 *         "mode": "MAPPING",
 *     },
 *     service_type="HTTP",
 *     http_service_config={
 *         "address": "http://apigateway-backend.alicloudapi.com:8080",
 *         "method": "GET",
 *         "path": "/web/cloudapi",
 *         "timeout": 12,
 *         "aone_name": "cloudapi-openapi",
 *     },
 *     request_parameters=[{
 *         "name": "example",
 *         "type": "STRING",
 *         "required": "OPTIONAL",
 *         "in_": "QUERY",
 *         "in_service": "QUERY",
 *         "name_service": "exampleservice",
 *     }],
 *     stage_names=[
 *         "RELEASE",
 *         "TEST",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.ApiGateway.Group("example", new()
 *     {
 *         Name = "tf-example",
 *         Description = "tf-example",
 *         BasePath = "/",
 *     });
 *     var exampleApi = new AliCloud.ApiGateway.Api("example", new()
 *     {
 *         GroupId = example.Id,
 *         Name = "tf-example",
 *         Description = "tf-example",
 *         AuthType = "APP",
 *         ForceNonceCheck = false,
 *         RequestConfig = new AliCloud.ApiGateway.Inputs.ApiRequestConfigArgs
 *         {
 *             Protocol = "HTTP",
 *             Method = "GET",
 *             Path = "/example/path",
 *             Mode = "MAPPING",
 *         },
 *         ServiceType = "HTTP",
 *         HttpServiceConfig = new AliCloud.ApiGateway.Inputs.ApiHttpServiceConfigArgs
 *         {
 *             Address = "http://apigateway-backend.alicloudapi.com:8080",
 *             Method = "GET",
 *             Path = "/web/cloudapi",
 *             Timeout = 12,
 *             AoneName = "cloudapi-openapi",
 *         },
 *         RequestParameters = new[]
 *         {
 *             new AliCloud.ApiGateway.Inputs.ApiRequestParameterArgs
 *             {
 *                 Name = "example",
 *                 Type = "STRING",
 *                 Required = "OPTIONAL",
 *                 In = "QUERY",
 *                 InService = "QUERY",
 *                 NameService = "exampleservice",
 *             },
 *         },
 *         StageNames = new[]
 *         {
 *             "RELEASE",
 *             "TEST",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apigateway.NewGroup(ctx, "example", &apigateway.GroupArgs{
 * 			Name:        pulumi.String("tf-example"),
 * 			Description: pulumi.String("tf-example"),
 * 			BasePath:    pulumi.String("/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewApi(ctx, "example", &apigateway.ApiArgs{
 * 			GroupId:         example.ID(),
 * 			Name:            pulumi.String("tf-example"),
 * 			Description:     pulumi.String("tf-example"),
 * 			AuthType:        pulumi.String("APP"),
 * 			ForceNonceCheck: pulumi.Bool(false),
 * 			RequestConfig: &apigateway.ApiRequestConfigArgs{
 * 				Protocol: pulumi.String("HTTP"),
 * 				Method:   pulumi.String("GET"),
 * 				Path:     pulumi.String("/example/path"),
 * 				Mode:     pulumi.String("MAPPING"),
 * 			},
 * 			ServiceType: pulumi.String("HTTP"),
 * 			HttpServiceConfig: &apigateway.ApiHttpServiceConfigArgs{
 * 				Address:  pulumi.String("http://apigateway-backend.alicloudapi.com:8080"),
 * 				Method:   pulumi.String("GET"),
 * 				Path:     pulumi.String("/web/cloudapi"),
 * 				Timeout:  pulumi.Int(12),
 * 				AoneName: pulumi.String("cloudapi-openapi"),
 * 			},
 * 			RequestParameters: apigateway.ApiRequestParameterArray{
 * 				&apigateway.ApiRequestParameterArgs{
 * 					Name:        pulumi.String("example"),
 * 					Type:        pulumi.String("STRING"),
 * 					Required:    pulumi.String("OPTIONAL"),
 * 					In:          pulumi.String("QUERY"),
 * 					InService:   pulumi.String("QUERY"),
 * 					NameService: pulumi.String("exampleservice"),
 * 				},
 * 			},
 * 			StageNames: pulumi.StringArray{
 * 				pulumi.String("RELEASE"),
 * 				pulumi.String("TEST"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Group;
 * import com.pulumi.alicloud.apigateway.GroupArgs;
 * import com.pulumi.alicloud.apigateway.Api;
 * import com.pulumi.alicloud.apigateway.ApiArgs;
 * import com.pulumi.alicloud.apigateway.inputs.ApiRequestConfigArgs;
 * import com.pulumi.alicloud.apigateway.inputs.ApiHttpServiceConfigArgs;
 * import com.pulumi.alicloud.apigateway.inputs.ApiRequestParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .name("tf-example")
 *             .description("tf-example")
 *             .basePath("/")
 *             .build());
 *         var exampleApi = new Api("exampleApi", ApiArgs.builder()
 *             .groupId(example.id())
 *             .name("tf-example")
 *             .description("tf-example")
 *             .authType("APP")
 *             .forceNonceCheck(false)
 *             .requestConfig(ApiRequestConfigArgs.builder()
 *                 .protocol("HTTP")
 *                 .method("GET")
 *                 .path("/example/path")
 *                 .mode("MAPPING")
 *                 .build())
 *             .serviceType("HTTP")
 *             .httpServiceConfig(ApiHttpServiceConfigArgs.builder()
 *                 .address("http://apigateway-backend.alicloudapi.com:8080")
 *                 .method("GET")
 *                 .path("/web/cloudapi")
 *                 .timeout(12)
 *                 .aoneName("cloudapi-openapi")
 *                 .build())
 *             .requestParameters(ApiRequestParameterArgs.builder()
 *                 .name("example")
 *                 .type("STRING")
 *                 .required("OPTIONAL")
 *                 .in("QUERY")
 *                 .inService("QUERY")
 *                 .nameService("exampleservice")
 *                 .build())
 *             .stageNames(
 *                 "RELEASE",
 *                 "TEST")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:apigateway:Group
 *     properties:
 *       name: tf-example
 *       description: tf-example
 *       basePath: /
 *   exampleApi:
 *     type: alicloud:apigateway:Api
 *     name: example
 *     properties:
 *       groupId: ${example.id}
 *       name: tf-example
 *       description: tf-example
 *       authType: APP
 *       forceNonceCheck: false
 *       requestConfig:
 *         protocol: HTTP
 *         method: GET
 *         path: /example/path
 *         mode: MAPPING
 *       serviceType: HTTP
 *       httpServiceConfig:
 *         address: http://apigateway-backend.alicloudapi.com:8080
 *         method: GET
 *         path: /web/cloudapi
 *         timeout: 12
 *         aoneName: cloudapi-openapi
 *       requestParameters:
 *         - name: example
 *           type: STRING
 *           required: OPTIONAL
 *           in: QUERY
 *           inService: QUERY
 *           nameService: exampleservice
 *       stageNames:
 *         - RELEASE
 *         - TEST
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api gateway api can be imported using the id.Format to `<API Group Id>:<API Id>` e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/api:Api example "ab2351f2ce904edaa8d92a0510832b91:e4f728fca5a94148b023b99a3e5d0b62"
 * ```
 * @property authType The authorization Type including APP and ANONYMOUS. Defaults to null.
 * @property constantParameters constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
 * @property description The description of the api. Defaults to null.
 * @property fcServiceConfig fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
 * @property forceNonceCheck Whether to prevent API replay attack. Default value: `false`.
 * @property groupId The api gateway that the api belongs to. Defaults to null.
 * @property httpServiceConfig http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
 * @property httpVpcServiceConfig http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
 * @property mockServiceConfig http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
 * @property name The name of the api gateway api. Defaults to null.
 * @property requestConfig Request_config defines how users can send requests to your API. See `request_config` below.
 * @property requestParameters request_parameters defines the request parameters of the api. See `request_parameters` below.
 * @property serviceType The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
 * @property stageNames Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
 * @property systemParameters system_parameters defines the system parameters of the api. See `system_parameters` below.
 */
public data class ApiArgs(
    public val authType: Output<String>? = null,
    public val constantParameters: Output<List<ApiConstantParameterArgs>>? = null,
    public val description: Output<String>? = null,
    public val fcServiceConfig: Output<ApiFcServiceConfigArgs>? = null,
    public val forceNonceCheck: Output<Boolean>? = null,
    public val groupId: Output<String>? = null,
    public val httpServiceConfig: Output<ApiHttpServiceConfigArgs>? = null,
    public val httpVpcServiceConfig: Output<ApiHttpVpcServiceConfigArgs>? = null,
    public val mockServiceConfig: Output<ApiMockServiceConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val requestConfig: Output<ApiRequestConfigArgs>? = null,
    public val requestParameters: Output<List<ApiRequestParameterArgs>>? = null,
    public val serviceType: Output<String>? = null,
    public val stageNames: Output<List<String>>? = null,
    public val systemParameters: Output<List<ApiSystemParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.ApiArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.ApiArgs =
        com.pulumi.alicloud.apigateway.ApiArgs.builder()
            .authType(authType?.applyValue({ args0 -> args0 }))
            .constantParameters(
                constantParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .fcServiceConfig(fcServiceConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forceNonceCheck(forceNonceCheck?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .httpServiceConfig(httpServiceConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpVpcServiceConfig(
                httpVpcServiceConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mockServiceConfig(mockServiceConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requestConfig(requestConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requestParameters(
                requestParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceType(serviceType?.applyValue({ args0 -> args0 }))
            .stageNames(stageNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .systemParameters(
                systemParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApiArgs].
 */
@PulumiTagMarker
public class ApiArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var constantParameters: Output<List<ApiConstantParameterArgs>>? = null

    private var description: Output<String>? = null

    private var fcServiceConfig: Output<ApiFcServiceConfigArgs>? = null

    private var forceNonceCheck: Output<Boolean>? = null

    private var groupId: Output<String>? = null

    private var httpServiceConfig: Output<ApiHttpServiceConfigArgs>? = null

    private var httpVpcServiceConfig: Output<ApiHttpVpcServiceConfigArgs>? = null

    private var mockServiceConfig: Output<ApiMockServiceConfigArgs>? = null

    private var name: Output<String>? = null

    private var requestConfig: Output<ApiRequestConfigArgs>? = null

    private var requestParameters: Output<List<ApiRequestParameterArgs>>? = null

    private var serviceType: Output<String>? = null

    private var stageNames: Output<List<String>>? = null

    private var systemParameters: Output<List<ApiSystemParameterArgs>>? = null

    /**
     * @param value The authorization Type including APP and ANONYMOUS. Defaults to null.
     */
    @JvmName("yonfxiswchggurhl")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    @JvmName("yarnjupltghkqxry")
    public suspend fun constantParameters(`value`: Output<List<ApiConstantParameterArgs>>) {
        this.constantParameters = value
    }

    @JvmName("irakvfkcbqxvdapu")
    public suspend fun constantParameters(vararg values: Output<ApiConstantParameterArgs>) {
        this.constantParameters = Output.all(values.asList())
    }

    /**
     * @param values constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    @JvmName("swohjncuqtcrxugq")
    public suspend fun constantParameters(values: List<Output<ApiConstantParameterArgs>>) {
        this.constantParameters = Output.all(values)
    }

    /**
     * @param value The description of the api. Defaults to null.
     */
    @JvmName("wwgqnidtbvynjena")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
     */
    @JvmName("isvxseyxknfrvuea")
    public suspend fun fcServiceConfig(`value`: Output<ApiFcServiceConfigArgs>) {
        this.fcServiceConfig = value
    }

    /**
     * @param value Whether to prevent API replay attack. Default value: `false`.
     */
    @JvmName("eqitomdjsxpmslgs")
    public suspend fun forceNonceCheck(`value`: Output<Boolean>) {
        this.forceNonceCheck = value
    }

    /**
     * @param value The api gateway that the api belongs to. Defaults to null.
     */
    @JvmName("hmgyuqhtvmcicait")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
     */
    @JvmName("rfivqqgfrypilcmd")
    public suspend fun httpServiceConfig(`value`: Output<ApiHttpServiceConfigArgs>) {
        this.httpServiceConfig = value
    }

    /**
     * @param value http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
     */
    @JvmName("apcmmevquejoemga")
    public suspend fun httpVpcServiceConfig(`value`: Output<ApiHttpVpcServiceConfigArgs>) {
        this.httpVpcServiceConfig = value
    }

    /**
     * @param value http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
     */
    @JvmName("ptauoydpubpwvsox")
    public suspend fun mockServiceConfig(`value`: Output<ApiMockServiceConfigArgs>) {
        this.mockServiceConfig = value
    }

    /**
     * @param value The name of the api gateway api. Defaults to null.
     */
    @JvmName("cnkgcjgeksperppd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Request_config defines how users can send requests to your API. See `request_config` below.
     */
    @JvmName("cblybujcidsgjlmp")
    public suspend fun requestConfig(`value`: Output<ApiRequestConfigArgs>) {
        this.requestConfig = value
    }

    /**
     * @param value request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    @JvmName("dlhofxxodkucifce")
    public suspend fun requestParameters(`value`: Output<List<ApiRequestParameterArgs>>) {
        this.requestParameters = value
    }

    @JvmName("buukucoptqjnpbcy")
    public suspend fun requestParameters(vararg values: Output<ApiRequestParameterArgs>) {
        this.requestParameters = Output.all(values.asList())
    }

    /**
     * @param values request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    @JvmName("plyvpswchobhesuc")
    public suspend fun requestParameters(values: List<Output<ApiRequestParameterArgs>>) {
        this.requestParameters = Output.all(values)
    }

    /**
     * @param value The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
     */
    @JvmName("lgewnrqrbsgwomgm")
    public suspend fun serviceType(`value`: Output<String>) {
        this.serviceType = value
    }

    /**
     * @param value Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
     */
    @JvmName("dkkfmfkqpysxvimo")
    public suspend fun stageNames(`value`: Output<List<String>>) {
        this.stageNames = value
    }

    @JvmName("cuxkmkifpnqlwxbo")
    public suspend fun stageNames(vararg values: Output<String>) {
        this.stageNames = Output.all(values.asList())
    }

    /**
     * @param values Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
     */
    @JvmName("xombqosphbucdusg")
    public suspend fun stageNames(values: List<Output<String>>) {
        this.stageNames = Output.all(values)
    }

    /**
     * @param value system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    @JvmName("wlpbbtufpqcqbphk")
    public suspend fun systemParameters(`value`: Output<List<ApiSystemParameterArgs>>) {
        this.systemParameters = value
    }

    @JvmName("wwpdnektxqcmqmxy")
    public suspend fun systemParameters(vararg values: Output<ApiSystemParameterArgs>) {
        this.systemParameters = Output.all(values.asList())
    }

    /**
     * @param values system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    @JvmName("kvbrxciiuibviyyl")
    public suspend fun systemParameters(values: List<Output<ApiSystemParameterArgs>>) {
        this.systemParameters = Output.all(values)
    }

    /**
     * @param value The authorization Type including APP and ANONYMOUS. Defaults to null.
     */
    @JvmName("xtyeosfpbgstlkir")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    @JvmName("ccfknvbisnwmeviv")
    public suspend fun constantParameters(`value`: List<ApiConstantParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constantParameters = mapped
    }

    /**
     * @param argument constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    @JvmName("vyfbswvoshdngdft")
    public suspend fun constantParameters(argument: List<suspend ApiConstantParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApiConstantParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.constantParameters = mapped
    }

    /**
     * @param argument constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    @JvmName("wcfueswtcwqmxrbe")
    public suspend fun constantParameters(vararg argument: suspend ApiConstantParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApiConstantParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.constantParameters = mapped
    }

    /**
     * @param argument constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    @JvmName("sntdoitufpfdqmle")
    public suspend fun constantParameters(argument: suspend ApiConstantParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApiConstantParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.constantParameters = mapped
    }

    /**
     * @param values constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
     */
    @JvmName("bkhpqxxmhkuxlisy")
    public suspend fun constantParameters(vararg values: ApiConstantParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.constantParameters = mapped
    }

    /**
     * @param value The description of the api. Defaults to null.
     */
    @JvmName("otnxauonuxeahimx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
     */
    @JvmName("tthgfcfqwvfqasxr")
    public suspend fun fcServiceConfig(`value`: ApiFcServiceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fcServiceConfig = mapped
    }

    /**
     * @param argument fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
     */
    @JvmName("iihiupdyomremblk")
    public suspend fun fcServiceConfig(argument: suspend ApiFcServiceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApiFcServiceConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fcServiceConfig = mapped
    }

    /**
     * @param value Whether to prevent API replay attack. Default value: `false`.
     */
    @JvmName("gvfqxbeobsemnwfk")
    public suspend fun forceNonceCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceNonceCheck = mapped
    }

    /**
     * @param value The api gateway that the api belongs to. Defaults to null.
     */
    @JvmName("yoytaepcblalgdgb")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
     */
    @JvmName("eltutlsrrsnalwqt")
    public suspend fun httpServiceConfig(`value`: ApiHttpServiceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpServiceConfig = mapped
    }

    /**
     * @param argument http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
     */
    @JvmName("onwpgfrcmyohensl")
    public suspend fun httpServiceConfig(argument: suspend ApiHttpServiceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApiHttpServiceConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpServiceConfig = mapped
    }

    /**
     * @param value http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
     */
    @JvmName("wtxaidcgrefyglvu")
    public suspend fun httpVpcServiceConfig(`value`: ApiHttpVpcServiceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpVpcServiceConfig = mapped
    }

    /**
     * @param argument http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
     */
    @JvmName("snkyeqdlddytdgot")
    public suspend fun httpVpcServiceConfig(argument: suspend ApiHttpVpcServiceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApiHttpVpcServiceConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpVpcServiceConfig = mapped
    }

    /**
     * @param value http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
     */
    @JvmName("caxrovudgxcumcbu")
    public suspend fun mockServiceConfig(`value`: ApiMockServiceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mockServiceConfig = mapped
    }

    /**
     * @param argument http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
     */
    @JvmName("edbwwxqiqoartrjj")
    public suspend fun mockServiceConfig(argument: suspend ApiMockServiceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApiMockServiceConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mockServiceConfig = mapped
    }

    /**
     * @param value The name of the api gateway api. Defaults to null.
     */
    @JvmName("sfkuwtifbydducal")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Request_config defines how users can send requests to your API. See `request_config` below.
     */
    @JvmName("pidgtbfewccvnhxx")
    public suspend fun requestConfig(`value`: ApiRequestConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestConfig = mapped
    }

    /**
     * @param argument Request_config defines how users can send requests to your API. See `request_config` below.
     */
    @JvmName("qteoegctwkqyvxti")
    public suspend fun requestConfig(argument: suspend ApiRequestConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApiRequestConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requestConfig = mapped
    }

    /**
     * @param value request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    @JvmName("vwjqvpetkwyrinjq")
    public suspend fun requestParameters(`value`: List<ApiRequestParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param argument request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    @JvmName("koexnpquniykmwaq")
    public suspend fun requestParameters(argument: List<suspend ApiRequestParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApiRequestParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param argument request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    @JvmName("lqheowowjhikddpm")
    public suspend fun requestParameters(vararg argument: suspend ApiRequestParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApiRequestParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param argument request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    @JvmName("vxtmprmwkxufqyjg")
    public suspend fun requestParameters(argument: suspend ApiRequestParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApiRequestParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param values request_parameters defines the request parameters of the api. See `request_parameters` below.
     */
    @JvmName("yytdbruehlwvpirn")
    public suspend fun requestParameters(vararg values: ApiRequestParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param value The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
     */
    @JvmName("mufhsyxqokmjxkja")
    public suspend fun serviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
     */
    @JvmName("wnmcoeijjriutkjg")
    public suspend fun stageNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageNames = mapped
    }

    /**
     * @param values Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
     */
    @JvmName("xqwldmvfdnpobfvn")
    public suspend fun stageNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageNames = mapped
    }

    /**
     * @param value system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    @JvmName("bqmlorgwwpuxiqoq")
    public suspend fun systemParameters(`value`: List<ApiSystemParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemParameters = mapped
    }

    /**
     * @param argument system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    @JvmName("ofjpyddgjhhsdnuk")
    public suspend fun systemParameters(argument: List<suspend ApiSystemParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApiSystemParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.systemParameters = mapped
    }

    /**
     * @param argument system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    @JvmName("ntupphnsbheglgja")
    public suspend fun systemParameters(vararg argument: suspend ApiSystemParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApiSystemParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.systemParameters = mapped
    }

    /**
     * @param argument system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    @JvmName("kbmpihvgogdeypxc")
    public suspend fun systemParameters(argument: suspend ApiSystemParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApiSystemParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.systemParameters = mapped
    }

    /**
     * @param values system_parameters defines the system parameters of the api. See `system_parameters` below.
     */
    @JvmName("usfjvrtjgptfygah")
    public suspend fun systemParameters(vararg values: ApiSystemParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemParameters = mapped
    }

    internal fun build(): ApiArgs = ApiArgs(
        authType = authType,
        constantParameters = constantParameters,
        description = description,
        fcServiceConfig = fcServiceConfig,
        forceNonceCheck = forceNonceCheck,
        groupId = groupId,
        httpServiceConfig = httpServiceConfig,
        httpVpcServiceConfig = httpVpcServiceConfig,
        mockServiceConfig = mockServiceConfig,
        name = name,
        requestConfig = requestConfig,
        requestParameters = requestParameters,
        serviceType = serviceType,
        stageNames = stageNames,
        systemParameters = systemParameters,
    )
}
