@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getApisPlain
import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getAppsPlain
import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getBackendsPlain
import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getGroupsPlain
import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getLogConfigsPlain
import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getModelsPlain
import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getPluginsPlain
import com.pulumi.alicloud.apigateway.ApigatewayFunctions.getServicePlain
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetApisPlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetApisPlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetAppsPlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetAppsPlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetBackendsPlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetBackendsPlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetLogConfigsPlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetLogConfigsPlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetModelsPlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetModelsPlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetPluginsPlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetPluginsPlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetApisResult
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetAppsResult
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetBackendsResult
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetGroupsResult
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetLogConfigsResult
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetModelsResult
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetPluginsResult
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetApisResult.Companion.toKotlin as getApisResultToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetAppsResult.Companion.toKotlin as getAppsResultToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetBackendsResult.Companion.toKotlin as getBackendsResultToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetGroupsResult.Companion.toKotlin as getGroupsResultToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetLogConfigsResult.Companion.toKotlin as getLogConfigsResultToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetModelsResult.Companion.toKotlin as getModelsResultToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetPluginsResult.Companion.toKotlin as getPluginsResultToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object ApigatewayFunctions {
    /**
     * This data source provides the Api Gateway APIs of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.22.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "terraform-example";
     * const _default = new alicloud.apigateway.Group("default", {
     *     name: name,
     *     description: name,
     * });
     * const defaultApi = new alicloud.apigateway.Api("default", {
     *     groupId: _default.id,
     *     name: name,
     *     description: name,
     *     authType: "APP",
     *     serviceType: "HTTP",
     *     requestConfig: {
     *         protocol: "HTTP",
     *         method: "GET",
     *         path: "/test/path",
     *         mode: "MAPPING",
     *     },
     *     httpServiceConfig: {
     *         address: "http://apigateway-backend.alicloudapi.com:8080",
     *         method: "GET",
     *         path: "/web/cloudapi",
     *         timeout: 20,
     *         aoneName: "cloudapi-openapi",
     *     },
     *     requestParameters: [{
     *         name: name,
     *         type: "STRING",
     *         required: "OPTIONAL",
     *         "in": "QUERY",
     *         inService: "QUERY",
     *         nameService: name,
     *     }],
     * });
     * const ids = alicloud.apigateway.getApisOutput({
     *     ids: [defaultApi&#46;id],
     * });
     * export const apiGatewayApisId0 = ids.apply(ids => ids.apis?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "terraform-example"
     * default = alicloud.apigateway.Group("default",
     *     name=name,
     *     description=name)
     * default_api = alicloud.apigateway.Api("default",
     *     group_id=default.id,
     *     name=name,
     *     description=name,
     *     auth_type="APP",
     *     service_type="HTTP",
     *     request_config={
     *         "protocol": "HTTP",
     *         "method": "GET",
     *         "path": "/test/path",
     *         "mode": "MAPPING",
     *     },
     *     http_service_config={
     *         "address": "http://apigateway-backend.alicloudapi.com:8080",
     *         "method": "GET",
     *         "path": "/web/cloudapi",
     *         "timeout": 20,
     *         "aone_name": "cloudapi-openapi",
     *     },
     *     request_parameters=[{
     *         "name": name,
     *         "type": "STRING",
     *         "required": "OPTIONAL",
     *         "in_": "QUERY",
     *         "in_service": "QUERY",
     *         "name_service": name,
     *     }])
     * ids = alicloud.apigateway.get_apis_output(ids=[default_api&#46;id])
     * pulumi.export("apiGatewayApisId0", ids.apis[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "terraform-example";
     *     var @default = new AliCloud.ApiGateway.Group("default", new()
     *     {
     *         Name = name,
     *         Description = name,
     *     });
     *     var defaultApi = new AliCloud.ApiGateway.Api("default", new()
     *     {
     *         GroupId = @default.Id,
     *         Name = name,
     *         Description = name,
     *         AuthType = "APP",
     *         ServiceType = "HTTP",
     *         RequestConfig = new AliCloud.ApiGateway.Inputs.ApiRequestConfigArgs
     *         {
     *             Protocol = "HTTP",
     *             Method = "GET",
     *             Path = "/test/path",
     *             Mode = "MAPPING",
     *         },
     *         HttpServiceConfig = new AliCloud.ApiGateway.Inputs.ApiHttpServiceConfigArgs
     *         {
     *             Address = "http://apigateway-backend.alicloudapi.com:8080",
     *             Method = "GET",
     *             Path = "/web/cloudapi",
     *             Timeout = 20,
     *             AoneName = "cloudapi-openapi",
     *         },
     *         RequestParameters = new[]
     *         {
     *             new AliCloud.ApiGateway.Inputs.ApiRequestParameterArgs
     *             {
     *                 Name = name,
     *                 Type = "STRING",
     *                 Required = "OPTIONAL",
     *                 In = "QUERY",
     *                 InService = "QUERY",
     *                 NameService = name,
     *             },
     *         },
     *     });
     *     var ids = AliCloud.ApiGateway.GetApis.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultApi.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["apiGatewayApisId0"] = ids&#46;Apply(getApisResult => getApisResult&#46;Apis[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "terraform-example"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := apigateway.NewGroup(ctx, "default", &apigateway.GroupArgs{
     * 			Name:        pulumi.String(name),
     * 			Description: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultApi, err := apigateway.NewApi(ctx, "default", &apigateway.ApiArgs{
     * 			GroupId:     _default.ID(),
     * 			Name:        pulumi.String(name),
     * 			Description: pulumi.String(name),
     * 			AuthType:    pulumi.String("APP"),
     * 			ServiceType: pulumi.String("HTTP"),
     * 			RequestConfig: &apigateway.ApiRequestConfigArgs{
     * 				Protocol: pulumi.String("HTTP"),
     * 				Method:   pulumi.String("GET"),
     * 				Path:     pulumi.String("/test/path"),
     * 				Mode:     pulumi.String("MAPPING"),
     * 			},
     * 			HttpServiceConfig: &apigateway.ApiHttpServiceConfigArgs{
     * 				Address:  pulumi.String("http://apigateway-backend.alicloudapi.com:8080"),
     * 				Method:   pulumi.String("GET"),
     * 				Path:     pulumi.String("/web/cloudapi"),
     * 				Timeout:  pulumi.Int(20),
     * 				AoneName: pulumi.String("cloudapi-openapi"),
     * 			},
     * 			RequestParameters: apigateway.ApiRequestParameterArray{
     * 				&apigateway.ApiRequestParameterArgs{
     * 					Name:        pulumi.String(name),
     * 					Type:        pulumi.String("STRING"),
     * 					Required:    pulumi.String("OPTIONAL"),
     * 					In:          pulumi.String("QUERY"),
     * 					InService:   pulumi.String("QUERY"),
     * 					NameService: pulumi.String(name),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := apigateway.GetApisOutput(ctx, apigateway.GetApisOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultApi.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("apiGatewayApisId0", ids.ApplyT(func(ids apigateway.GetApisResult) (*string, error) {
     * 			return &ids.Apis[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.Group;
     * import com.pulumi.alicloud.apigateway.GroupArgs;
     * import com.pulumi.alicloud.apigateway.Api;
     * import com.pulumi.alicloud.apigateway.ApiArgs;
     * import com.pulumi.alicloud.apigateway.inputs.ApiRequestConfigArgs;
     * import com.pulumi.alicloud.apigateway.inputs.ApiHttpServiceConfigArgs;
     * import com.pulumi.alicloud.apigateway.inputs.ApiRequestParameterArgs;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetApisArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("terraform-example");
     *         var default_ = new Group("default", GroupArgs.builder()
     *             .name(name)
     *             .description(name)
     *             .build());
     *         var defaultApi = new Api("defaultApi", ApiArgs.builder()
     *             .groupId(default_.id())
     *             .name(name)
     *             .description(name)
     *             .authType("APP")
     *             .serviceType("HTTP")
     *             .requestConfig(ApiRequestConfigArgs.builder()
     *                 .protocol("HTTP")
     *                 .method("GET")
     *                 .path("/test/path")
     *                 .mode("MAPPING")
     *                 .build())
     *             .httpServiceConfig(ApiHttpServiceConfigArgs.builder()
     *                 .address("http://apigateway-backend.alicloudapi.com:8080")
     *                 .method("GET")
     *                 .path("/web/cloudapi")
     *                 .timeout(20)
     *                 .aoneName("cloudapi-openapi")
     *                 .build())
     *             .requestParameters(ApiRequestParameterArgs.builder()
     *                 .name(name)
     *                 .type("STRING")
     *                 .required("OPTIONAL")
     *                 .in("QUERY")
     *                 .inService("QUERY")
     *                 .nameService(name)
     *                 .build())
     *             .build());
     *         final var ids = ApigatewayFunctions.getApis(GetApisArgs.builder()
     *             .ids(defaultApi.id())
     *             .build());
     *         ctx.export("apiGatewayApisId0", ids.applyValue(getApisResult -> getApisResult).applyValue(ids -> ids.applyValue(getApisResult -> getApisResult.apis()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: terraform-example
     * resources:
     *   default:
     *     type: alicloud:apigateway:Group
     *     properties:
     *       name: ${name}
     *       description: ${name}
     *   defaultApi:
     *     type: alicloud:apigateway:Api
     *     name: default
     *     properties:
     *       groupId: ${default.id}
     *       name: ${name}
     *       description: ${name}
     *       authType: APP
     *       serviceType: HTTP
     *       requestConfig:
     *         protocol: HTTP
     *         method: GET
     *         path: /test/path
     *         mode: MAPPING
     *       httpServiceConfig:
     *         address: http://apigateway-backend.alicloudapi.com:8080
     *         method: GET
     *         path: /web/cloudapi
     *         timeout: 20
     *         aoneName: cloudapi-openapi
     *       requestParameters:
     *         - name: ${name}
     *           type: STRING
     *           required: OPTIONAL
     *           in: QUERY
     *           inService: QUERY
     *           nameService: ${name}
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getApis
     *       Arguments:
     *         ids:
     *           - ${defaultApi.id}
     * outputs:
     *   apiGatewayApisId0: ${ids.apis[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApis.
     * @return A collection of values returned by getApis.
     */
    public suspend fun getApis(argument: GetApisPlainArgs): GetApisResult =
        getApisResultToKotlin(getApisPlain(argument.toJava()).await())

    /**
     * @see [getApis].
     * @param apiId The ID of the API.
     * @param groupId The ID of the API group.
     * @param ids A list of API IDs.
     * @param nameRegex A regex string to filter results by API name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getApis.
     */
    public suspend fun getApis(
        apiId: String? = null,
        groupId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetApisResult {
        val argument = GetApisPlainArgs(
            apiId = apiId,
            groupId = groupId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getApisResultToKotlin(getApisPlain(argument.toJava()).await())
    }

    /**
     * @see [getApis].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetApisPlainArgs].
     * @return A collection of values returned by getApis.
     */
    public suspend fun getApis(argument: suspend GetApisPlainArgsBuilder.() -> Unit): GetApisResult {
        val builder = GetApisPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApisResultToKotlin(getApisPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the apps of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const dataApigatway = alicloud.apigateway.getApps({
     *     outputFile: "outapps",
     * });
     * export const firstAppId = dataApigatway.then(dataApigatway => dataApigatway.apps?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * data_apigatway = alicloud.apigateway.get_apps(output_file="outapps")
     * pulumi.export("firstAppId", data_apigatway.apps[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var dataApigatway = AliCloud.ApiGateway.GetApps.Invoke(new()
     *     {
     *         OutputFile = "outapps",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstAppId"] = dataApigatway&#46;Apply(getAppsResult => getAppsResult&#46;Apps[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		dataApigatway, err := apigateway.GetApps(ctx, &apigateway.GetAppsArgs{
     * 			OutputFile: pulumi.StringRef("outapps"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstAppId", dataApigatway.Apps[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetAppsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var dataApigatway = ApigatewayFunctions.getApps(GetAppsArgs.builder()
     *             .outputFile("outapps")
     *             .build());
     *         ctx.export("firstAppId", dataApigatway.applyValue(getAppsResult -> getAppsResult.apps()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   dataApigatway:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getApps
     *       Arguments:
     *         outputFile: outapps
     * outputs:
     *   firstAppId: ${dataApigatway.apps[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApps.
     * @return A collection of values returned by getApps.
     */
    public suspend fun getApps(argument: GetAppsPlainArgs): GetAppsResult =
        getAppsResultToKotlin(getAppsPlain(argument.toJava()).await())

    /**
     * @see [getApps].
     * @param ids A list of app IDs.
     * @param nameRegex A regex string to filter apps by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getApps.
     */
    public suspend fun getApps(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetAppsResult {
        val argument = GetAppsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getAppsResultToKotlin(getAppsPlain(argument.toJava()).await())
    }

    /**
     * @see [getApps].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetAppsPlainArgs].
     * @return A collection of values returned by getApps.
     */
    public suspend fun getApps(argument: suspend GetAppsPlainArgsBuilder.() -> Unit): GetAppsResult {
        val builder = GetAppsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppsResultToKotlin(getAppsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Api Gateway Backends of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.181.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.apigateway.getBackends({});
     * export const apiGatewayBackendId1 = ids.then(ids => ids.backends?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.apigateway.get_backends()
     * pulumi.export("apiGatewayBackendId1", ids.backends[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ApiGateway.GetBackends.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["apiGatewayBackendId1"] = ids&#46;Apply(getBackendsResult => getBackendsResult&#46;Backends[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := apigateway.GetBackends(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("apiGatewayBackendId1", ids.Backends[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetBackendsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ApigatewayFunctions.getBackends();
     *         ctx.export("apiGatewayBackendId1", ids.applyValue(getBackendsResult -> getBackendsResult.backends()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getBackends
     *       Arguments: {}
     * outputs:
     *   apiGatewayBackendId1: ${ids.backends[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBackends.
     * @return A collection of values returned by getBackends.
     */
    public suspend fun getBackends(argument: GetBackendsPlainArgs): GetBackendsResult =
        getBackendsResultToKotlin(getBackendsPlain(argument.toJava()).await())

    /**
     * @see [getBackends].
     * @param ids A list of Backends IDs.
     * @param nameRegex A regex string to filter Api Gateway Backends by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getBackends.
     */
    public suspend fun getBackends(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetBackendsResult {
        val argument = GetBackendsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getBackendsResultToKotlin(getBackendsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackends].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetBackendsPlainArgs].
     * @return A collection of values returned by getBackends.
     */
    public suspend fun getBackends(argument: suspend GetBackendsPlainArgsBuilder.() -> Unit): GetBackendsResult {
        val builder = GetBackendsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackendsResultToKotlin(getBackendsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the api groups of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const dataApigatway = alicloud.apigateway.getGroups({
     *     outputFile: "outgroups",
     * });
     * export const firstGroupId = dataApigatway.then(dataApigatway => dataApigatway.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * data_apigatway = alicloud.apigateway.get_groups(output_file="outgroups")
     * pulumi.export("firstGroupId", data_apigatway.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var dataApigatway = AliCloud.ApiGateway.GetGroups.Invoke(new()
     *     {
     *         OutputFile = "outgroups",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGroupId"] = dataApigatway&#46;Apply(getGroupsResult => getGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		dataApigatway, err := apigateway.GetGroups(ctx, &apigateway.GetGroupsArgs{
     * 			OutputFile: pulumi.StringRef("outgroups"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGroupId", dataApigatway.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var dataApigatway = ApigatewayFunctions.getGroups(GetGroupsArgs.builder()
     *             .outputFile("outgroups")
     *             .build());
     *         ctx.export("firstGroupId", dataApigatway.applyValue(getGroupsResult -> getGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   dataApigatway:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getGroups
     *       Arguments:
     *         outputFile: outgroups
     * outputs:
     *   firstGroupId: ${dataApigatway.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param ids A list of api group IDs.
     * @param nameRegex A regex string to filter api gateway groups by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsResultToKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Api Gateway Log Configs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.185.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.apigateway.getLogConfigs({
     *     ids: ["example_id"],
     * });
     * export const apiGatewayLogConfigId1 = ids.then(ids => ids.configs?.[0]?.id);
     * const logType = alicloud.apigateway.getLogConfigs({
     *     logType: "PROVIDER",
     * });
     * export const apiGatewayLogConfigId2 = logType.then(logType => logType.configs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.apigateway.get_log_configs(ids=["example_id"])
     * pulumi.export("apiGatewayLogConfigId1", ids.configs[0].id)
     * log_type = alicloud.apigateway.get_log_configs(log_type="PROVIDER")
     * pulumi.export("apiGatewayLogConfigId2", log_type.configs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ApiGateway.GetLogConfigs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var logType = AliCloud.ApiGateway.GetLogConfigs.Invoke(new()
     *     {
     *         LogType = "PROVIDER",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["apiGatewayLogConfigId1"] = ids&#46;Apply(getLogConfigsResult => getLogConfigsResult&#46;Configs[0]?.Id),
     *         ["apiGatewayLogConfigId2"] = logType&#46;Apply(getLogConfigsResult => getLogConfigsResult&#46;Configs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := apigateway.GetLogConfigs(ctx, &apigateway.GetLogConfigsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("apiGatewayLogConfigId1", ids.Configs[0].Id)
     * 		logType, err := apigateway.GetLogConfigs(ctx, &apigateway.GetLogConfigsArgs{
     * 			LogType: pulumi.StringRef("PROVIDER"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("apiGatewayLogConfigId2", logType.Configs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetLogConfigsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ApigatewayFunctions.getLogConfigs(GetLogConfigsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("apiGatewayLogConfigId1", ids.applyValue(getLogConfigsResult -> getLogConfigsResult.configs()[0].id()));
     *         final var logType = ApigatewayFunctions.getLogConfigs(GetLogConfigsArgs.builder()
     *             .logType("PROVIDER")
     *             .build());
     *         ctx.export("apiGatewayLogConfigId2", logType.applyValue(getLogConfigsResult -> getLogConfigsResult.configs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getLogConfigs
     *       Arguments:
     *         ids:
     *           - example_id
     *   logType:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getLogConfigs
     *       Arguments:
     *         logType: PROVIDER
     * outputs:
     *   apiGatewayLogConfigId1: ${ids.configs[0].id}
     *   apiGatewayLogConfigId2: ${logType.configs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLogConfigs.
     * @return A collection of values returned by getLogConfigs.
     */
    public suspend fun getLogConfigs(argument: GetLogConfigsPlainArgs): GetLogConfigsResult =
        getLogConfigsResultToKotlin(getLogConfigsPlain(argument.toJava()).await())

    /**
     * @see [getLogConfigs].
     * @param ids A list of Log Config IDs.
     * @param logType The type the of log. Valid values: `PROVIDER`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getLogConfigs.
     */
    public suspend fun getLogConfigs(
        ids: List<String>? = null,
        logType: String? = null,
        outputFile: String? = null,
    ): GetLogConfigsResult {
        val argument = GetLogConfigsPlainArgs(
            ids = ids,
            logType = logType,
            outputFile = outputFile,
        )
        return getLogConfigsResultToKotlin(getLogConfigsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogConfigs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetLogConfigsPlainArgs].
     * @return A collection of values returned by getLogConfigs.
     */
    public suspend fun getLogConfigs(argument: suspend GetLogConfigsPlainArgsBuilder.() -> Unit): GetLogConfigsResult {
        val builder = GetLogConfigsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogConfigsResultToKotlin(getLogConfigsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Api Gateway Models of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.187.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.apigateway.getModels({
     *     ids: ["example_id"],
     *     groupId: "example_group_id",
     * });
     * export const apiGatewayModelId1 = ids.then(ids => ids.models?.[0]?.id);
     * const groupId = alicloud.apigateway.getModels({
     *     groupId: "example_group_id",
     * });
     * export const apiGatewayModelId2 = groupId.then(groupId => groupId.models?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.apigateway.get_models(ids=["example_id"],
     *     group_id="example_group_id")
     * pulumi.export("apiGatewayModelId1", ids.models[0].id)
     * group_id = alicloud.apigateway.get_models(group_id="example_group_id")
     * pulumi.export("apiGatewayModelId2", group_id.models[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ApiGateway.GetModels.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         GroupId = "example_group_id",
     *     });
     *     var groupId = AliCloud.ApiGateway.GetModels.Invoke(new()
     *     {
     *         GroupId = "example_group_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["apiGatewayModelId1"] = ids&#46;Apply(getModelsResult => getModelsResult&#46;Models[0]?.Id),
     *         ["apiGatewayModelId2"] = groupId&#46;Apply(getModelsResult => getModelsResult&#46;Models[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := apigateway.GetModels(ctx, &apigateway.GetModelsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			GroupId: "example_group_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("apiGatewayModelId1", ids.Models[0].Id)
     * 		groupId, err := apigateway.GetModels(ctx, &apigateway.GetModelsArgs{
     * 			GroupId: "example_group_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("apiGatewayModelId2", groupId.Models[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetModelsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ApigatewayFunctions.getModels(GetModelsArgs.builder()
     *             .ids("example_id")
     *             .groupId("example_group_id")
     *             .build());
     *         ctx.export("apiGatewayModelId1", ids.applyValue(getModelsResult -> getModelsResult.models()[0].id()));
     *         final var groupId = ApigatewayFunctions.getModels(GetModelsArgs.builder()
     *             .groupId("example_group_id")
     *             .build());
     *         ctx.export("apiGatewayModelId2", groupId.applyValue(getModelsResult -> getModelsResult.models()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getModels
     *       Arguments:
     *         ids:
     *           - example_id
     *         groupId: example_group_id
     *   groupId:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getModels
     *       Arguments:
     *         groupId: example_group_id
     * outputs:
     *   apiGatewayModelId1: ${ids.models[0].id}
     *   apiGatewayModelId2: ${groupId.models[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getModels.
     * @return A collection of values returned by getModels.
     */
    public suspend fun getModels(argument: GetModelsPlainArgs): GetModelsResult =
        getModelsResultToKotlin(getModelsPlain(argument.toJava()).await())

    /**
     * @see [getModels].
     * @param groupId The ID of the api group.
     * @param ids A list of Model IDs.
     * @param modelName The name of the Model.
     * @param nameRegex A regex string to filter results by Model name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getModels.
     */
    public suspend fun getModels(
        groupId: String,
        ids: List<String>? = null,
        modelName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetModelsResult {
        val argument = GetModelsPlainArgs(
            groupId = groupId,
            ids = ids,
            modelName = modelName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getModelsResultToKotlin(getModelsPlain(argument.toJava()).await())
    }

    /**
     * @see [getModels].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetModelsPlainArgs].
     * @return A collection of values returned by getModels.
     */
    public suspend fun getModels(argument: suspend GetModelsPlainArgsBuilder.() -> Unit): GetModelsResult {
        val builder = GetModelsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModelsResultToKotlin(getModelsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Api Gateway Plugins of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.187.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.apigateway.getPlugins({});
     * export const apiGatewayPluginId1 = ids.then(ids => ids.plugins?.[0]?.id);
     * const nameRegex = alicloud.apigateway.getPlugins({
     *     nameRegex: "^my-Plugin",
     * });
     * export const apiGatewayPluginId2 = nameRegex.then(nameRegex => nameRegex.plugins?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.apigateway.get_plugins()
     * pulumi.export("apiGatewayPluginId1", ids.plugins[0].id)
     * name_regex = alicloud.apigateway.get_plugins(name_regex="^my-Plugin")
     * pulumi.export("apiGatewayPluginId2", name_regex.plugins[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ApiGateway.GetPlugins.Invoke();
     *     var nameRegex = AliCloud.ApiGateway.GetPlugins.Invoke(new()
     *     {
     *         NameRegex = "^my-Plugin",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["apiGatewayPluginId1"] = ids&#46;Apply(getPluginsResult => getPluginsResult&#46;Plugins[0]?.Id),
     *         ["apiGatewayPluginId2"] = nameRegex&#46;Apply(getPluginsResult => getPluginsResult&#46;Plugins[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := apigateway.GetPlugins(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("apiGatewayPluginId1", ids.Plugins[0].Id)
     * 		nameRegex, err := apigateway.GetPlugins(ctx, &apigateway.GetPluginsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Plugin"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("apiGatewayPluginId2", nameRegex.Plugins[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetPluginsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ApigatewayFunctions.getPlugins();
     *         ctx.export("apiGatewayPluginId1", ids.applyValue(getPluginsResult -> getPluginsResult.plugins()[0].id()));
     *         final var nameRegex = ApigatewayFunctions.getPlugins(GetPluginsArgs.builder()
     *             .nameRegex("^my-Plugin")
     *             .build());
     *         ctx.export("apiGatewayPluginId2", nameRegex.applyValue(getPluginsResult -> getPluginsResult.plugins()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getPlugins
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getPlugins
     *       Arguments:
     *         nameRegex: ^my-Plugin
     * outputs:
     *   apiGatewayPluginId1: ${ids.plugins[0].id}
     *   apiGatewayPluginId2: ${nameRegex.plugins[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPlugins.
     * @return A collection of values returned by getPlugins.
     */
    public suspend fun getPlugins(argument: GetPluginsPlainArgs): GetPluginsResult =
        getPluginsResultToKotlin(getPluginsPlain(argument.toJava()).await())

    /**
     * @see [getPlugins].
     * @param ids A list of Plugin IDs.
     * @param nameRegex A regex string to filter results by Plugin name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param pluginName The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
     * @param pluginType The type of the plug-in. Valid values: `backendSignature`, `caching`, `cors`, `ipControl`, `jwtAuth`, `trafficControl`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getPlugins.
     */
    public suspend fun getPlugins(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        pluginName: String? = null,
        pluginType: String? = null,
        tags: Map<String, String>? = null,
    ): GetPluginsResult {
        val argument = GetPluginsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            pluginName = pluginName,
            pluginType = pluginType,
            tags = tags,
        )
        return getPluginsResultToKotlin(getPluginsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPlugins].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetPluginsPlainArgs].
     * @return A collection of values returned by getPlugins.
     */
    public suspend fun getPlugins(argument: suspend GetPluginsPlainArgsBuilder.() -> Unit): GetPluginsResult {
        val builder = GetPluginsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPluginsResultToKotlin(getPluginsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can enable API gateway service automatically. If the service has been enabled, it will return `Opened`.
     * For information about API Gateway and how to use it, see [What is API Gateway](https://www.alibabacloud.com/help/product/29462.htm).
     * > **NOTE:** Available in v1.96.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.apigateway.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.apigateway.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.ApiGateway.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.GetService(ctx, &apigateway.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.apigateway.ApigatewayFunctions;
     * import com.pulumi.alicloud.apigateway.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = ApigatewayFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:apigateway:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the API gateway service that means you have read and agreed the [API Gateway Terms of Service](https://help.aliyun.com/document_detail/35391.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;apigateway&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
