@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [App].
 */
@PulumiTagMarker
public class AppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppArgs = AppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppArgsBuilder.() -> Unit) {
        val builder = AppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): App {
        val builtJavaResource = com.pulumi.alicloud.apigateway.App(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return App(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.apigateway.App("example", {
 *     name: "tf_example",
 *     description: "tf_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.apigateway.App("example",
 *     name="tf_example",
 *     description="tf_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.ApiGateway.App("example", new()
 *     {
 *         Name = "tf_example",
 *         Description = "tf_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewApp(ctx, "example", &apigateway.AppArgs{
 * 			Name:        pulumi.String("tf_example"),
 * 			Description: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.App;
 * import com.pulumi.alicloud.apigateway.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("tf_example")
 *             .description("tf_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:apigateway:App
 *     properties:
 *       name: tf_example
 *       description: tf_example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api gateway app can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/app:App example "7379660"
 * ```
 */
public class App internal constructor(
    override val javaResource: com.pulumi.alicloud.apigateway.App,
) : KotlinCustomResource(javaResource, AppMapper) {
    /**
     * The description of the app. Defaults to null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the app.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object AppMapper : ResourceMapper<App> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.apigateway.App::class == javaResource::class

    override fun map(javaResource: Resource): App = App(
        javaResource as
            com.pulumi.alicloud.apigateway.App,
    )
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [App].
 */
public suspend fun app(name: String, block: suspend AppResourceBuilder.() -> Unit): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 */
public fun app(name: String): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    return builder.build()
}
