@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.AppArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.apigateway.App("example", {
 *     name: "tf_example",
 *     description: "tf_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.apigateway.App("example",
 *     name="tf_example",
 *     description="tf_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.ApiGateway.App("example", new()
 *     {
 *         Name = "tf_example",
 *         Description = "tf_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewApp(ctx, "example", &apigateway.AppArgs{
 * 			Name:        pulumi.String("tf_example"),
 * 			Description: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.App;
 * import com.pulumi.alicloud.apigateway.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("tf_example")
 *             .description("tf_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:apigateway:App
 *     properties:
 *       name: tf_example
 *       description: tf_example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api gateway app can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/app:App example "7379660"
 * ```
 * @property description The description of the app. Defaults to null.
 * @property name The name of the app.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class AppArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.AppArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.AppArgs =
        com.pulumi.alicloud.apigateway.AppArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the app. Defaults to null.
     */
    @JvmName("xkbfprmqljmyqtlf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the app.
     */
    @JvmName("cwwosxldfkespkff")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("nnoltmykrcpwjeyk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the app. Defaults to null.
     */
    @JvmName("fshsvisfrxyamppa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the app.
     */
    @JvmName("ffulgiwgwmoegmid")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("uhwbfwtwbkclrjuu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("vivdxwjajsgsehbn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        description = description,
        name = name,
        tags = tags,
    )
}
