@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Backend].
 */
@PulumiTagMarker
public class BackendResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackendArgs = BackendArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackendArgsBuilder.() -> Unit) {
        val builder = BackendArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Backend {
        val builtJavaResource = com.pulumi.alicloud.apigateway.Backend(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Backend(builtJavaResource)
    }
}

/**
 * Provides a Api Gateway Backend resource.
 * For information about Api Gateway Backend and how to use it, see [What is Backend](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createbackend).
 * > **NOTE:** Available since v1.181.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.apigateway.Backend("default", {
 *     backendName: name,
 *     description: name,
 *     backendType: "HTTP",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.apigateway.Backend("default",
 *     backend_name=name,
 *     description=name,
 *     backend_type="HTTP")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.ApiGateway.Backend("default", new()
 *     {
 *         BackendName = name,
 *         Description = name,
 *         BackendType = "HTTP",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := apigateway.NewBackend(ctx, "default", &apigateway.BackendArgs{
 * 			BackendName: pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			BackendType: pulumi.String("HTTP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Backend;
 * import com.pulumi.alicloud.apigateway.BackendArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Backend("default", BackendArgs.builder()
 *             .backendName(name)
 *             .description(name)
 *             .backendType("HTTP")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:apigateway:Backend
 *     properties:
 *       backendName: ${name}
 *       description: ${name}
 *       backendType: HTTP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Backend can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/backend:Backend example <id>
 * ```
 */
public class Backend internal constructor(
    override val javaResource: com.pulumi.alicloud.apigateway.Backend,
) : KotlinCustomResource(javaResource, BackendMapper) {
    /**
     * The name of the Backend.
     */
    public val backendName: Output<String>
        get() = javaResource.backendName().applyValue({ args0 -> args0 })

    /**
     * The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_HTTP`, `OSS`, `MOCK`.
     */
    public val backendType: Output<String>
        get() = javaResource.backendType().applyValue({ args0 -> args0 })

    /**
     * Whether to create an Event bus service association role.
     */
    public val createEventBridgeServiceLinkedRole: Output<Boolean>?
        get() = javaResource.createEventBridgeServiceLinkedRole().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The description of the Backend.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BackendMapper : ResourceMapper<Backend> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.apigateway.Backend::class == javaResource::class

    override fun map(javaResource: Resource): Backend = Backend(
        javaResource as
            com.pulumi.alicloud.apigateway.Backend,
    )
}

/**
 * @see [Backend].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Backend].
 */
public suspend fun backend(name: String, block: suspend BackendResourceBuilder.() -> Unit): Backend {
    val builder = BackendResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Backend].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backend(name: String): Backend {
    val builder = BackendResourceBuilder()
    builder.name(name)
    return builder.build()
}
