@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.BackendArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Api Gateway Backend resource.
 * For information about Api Gateway Backend and how to use it, see [What is Backend](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createbackend).
 * > **NOTE:** Available since v1.181.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.apigateway.Backend("default", {
 *     backendName: name,
 *     description: name,
 *     backendType: "HTTP",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.apigateway.Backend("default",
 *     backend_name=name,
 *     description=name,
 *     backend_type="HTTP")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.ApiGateway.Backend("default", new()
 *     {
 *         BackendName = name,
 *         Description = name,
 *         BackendType = "HTTP",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := apigateway.NewBackend(ctx, "default", &apigateway.BackendArgs{
 * 			BackendName: pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			BackendType: pulumi.String("HTTP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Backend;
 * import com.pulumi.alicloud.apigateway.BackendArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Backend("default", BackendArgs.builder()
 *             .backendName(name)
 *             .description(name)
 *             .backendType("HTTP")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:apigateway:Backend
 *     properties:
 *       backendName: ${name}
 *       description: ${name}
 *       backendType: HTTP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Backend can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/backend:Backend example <id>
 * ```
 * @property backendName The name of the Backend.
 * @property backendType The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_HTTP`, `OSS`, `MOCK`.
 * @property createEventBridgeServiceLinkedRole Whether to create an Event bus service association role.
 * @property description The description of the Backend.
 */
public data class BackendArgs(
    public val backendName: Output<String>? = null,
    public val backendType: Output<String>? = null,
    public val createEventBridgeServiceLinkedRole: Output<Boolean>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.BackendArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.BackendArgs =
        com.pulumi.alicloud.apigateway.BackendArgs.builder()
            .backendName(backendName?.applyValue({ args0 -> args0 }))
            .backendType(backendType?.applyValue({ args0 -> args0 }))
            .createEventBridgeServiceLinkedRole(
                createEventBridgeServiceLinkedRole?.applyValue({ args0 ->
                    args0
                }),
            )
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendArgs].
 */
@PulumiTagMarker
public class BackendArgsBuilder internal constructor() {
    private var backendName: Output<String>? = null

    private var backendType: Output<String>? = null

    private var createEventBridgeServiceLinkedRole: Output<Boolean>? = null

    private var description: Output<String>? = null

    /**
     * @param value The name of the Backend.
     */
    @JvmName("rqbmqenuerifutao")
    public suspend fun backendName(`value`: Output<String>) {
        this.backendName = value
    }

    /**
     * @param value The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_HTTP`, `OSS`, `MOCK`.
     */
    @JvmName("xshpovikikdvqlej")
    public suspend fun backendType(`value`: Output<String>) {
        this.backendType = value
    }

    /**
     * @param value Whether to create an Event bus service association role.
     */
    @JvmName("ritumskhnrlgimcc")
    public suspend fun createEventBridgeServiceLinkedRole(`value`: Output<Boolean>) {
        this.createEventBridgeServiceLinkedRole = value
    }

    /**
     * @param value The description of the Backend.
     */
    @JvmName("ngbsdtjntralffvk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Backend.
     */
    @JvmName("wuagakbqhqjkdgoh")
    public suspend fun backendName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendName = mapped
    }

    /**
     * @param value The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_HTTP`, `OSS`, `MOCK`.
     */
    @JvmName("iyqdfrmtbcpaoqaw")
    public suspend fun backendType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendType = mapped
    }

    /**
     * @param value Whether to create an Event bus service association role.
     */
    @JvmName("qupmmbhpkcegcsxh")
    public suspend fun createEventBridgeServiceLinkedRole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createEventBridgeServiceLinkedRole = mapped
    }

    /**
     * @param value The description of the Backend.
     */
    @JvmName("uiarccwyhsxkpgrt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): BackendArgs = BackendArgs(
        backendName = backendName,
        backendType = backendType,
        createEventBridgeServiceLinkedRole = createEventBridgeServiceLinkedRole,
        description = description,
    )
}
