@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.apigateway.Group("default", {
 *     name: "tf_example",
 *     description: "tf_example",
 *     basePath: "/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.apigateway.Group("default",
 *     name="tf_example",
 *     description="tf_example",
 *     base_path="/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ApiGateway.Group("default", new()
 *     {
 *         Name = "tf_example",
 *         Description = "tf_example",
 *         BasePath = "/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewGroup(ctx, "default", &apigateway.GroupArgs{
 * 			Name:        pulumi.String("tf_example"),
 * 			Description: pulumi.String("tf_example"),
 * 			BasePath:    pulumi.String("/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Group;
 * import com.pulumi.alicloud.apigateway.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Group("default", GroupArgs.builder()
 *             .name("tf_example")
 *             .description("tf_example")
 *             .basePath("/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:apigateway:Group
 *     properties:
 *       name: tf_example
 *       description: tf_example
 *       basePath: /
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api gateway group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/group:Group example "ab2351f2ce904edaa8d92a0510832b91"
 * ```
 * @property basePath The base path of the api gateway group. Defaults to `/`.
 * @property description The description of the api gateway group. Defaults to null.
 * @property instanceId The id of the api gateway.
 * @property name The name of the api gateway group. Defaults to null.
 */
public data class GroupArgs(
    public val basePath: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.GroupArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.GroupArgs =
        com.pulumi.alicloud.apigateway.GroupArgs.builder()
            .basePath(basePath?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var basePath: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The base path of the api gateway group. Defaults to `/`.
     */
    @JvmName("xwryinwxyjwqptpf")
    public suspend fun basePath(`value`: Output<String>) {
        this.basePath = value
    }

    /**
     * @param value The description of the api gateway group. Defaults to null.
     */
    @JvmName("anlkmgfbidctxyld")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The id of the api gateway.
     */
    @JvmName("vgfquoqytfshgpip")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of the api gateway group. Defaults to null.
     */
    @JvmName("xfyyphnndunudlhy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The base path of the api gateway group. Defaults to `/`.
     */
    @JvmName("hlgbunwpbcrjoack")
    public suspend fun basePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basePath = mapped
    }

    /**
     * @param value The description of the api gateway group. Defaults to null.
     */
    @JvmName("kwbhehcltlknobaj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The id of the api gateway.
     */
    @JvmName("ceuspdvkrkqjjouj")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the api gateway group. Defaults to null.
     */
    @JvmName("xfllacfksnthksfx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        basePath = basePath,
        description = description,
        instanceId = instanceId,
        name = name,
    )
}
