@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.kotlin.outputs.InstanceToConnectVpcIpBlock
import com.pulumi.alicloud.apigateway.kotlin.outputs.InstanceZoneVswitchSecurityGroup
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.apigateway.kotlin.outputs.InstanceToConnectVpcIpBlock.Companion.toKotlin as instanceToConnectVpcIpBlockToKotlin
import com.pulumi.alicloud.apigateway.kotlin.outputs.InstanceZoneVswitchSecurityGroup.Companion.toKotlin as instanceZoneVswitchSecurityGroupToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.apigateway.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a Api Gateway Instance resource.
 * For information about Api Gateway Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/api-gateway/product-overview/dedicated-instances).
 * > **NOTE:** Available since v1.218.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.apigateway.Instance("default", {
 *     instanceName: name,
 *     instanceSpec: "api.s1.small",
 *     httpsPolicy: "HTTPS2_TLS1_0",
 *     zoneId: "cn-hangzhou-MAZ6",
 *     paymentType: "PayAsYouGo",
 *     instanceType: "normal",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.apigateway.Instance("default",
 *     instance_name=name,
 *     instance_spec="api.s1.small",
 *     https_policy="HTTPS2_TLS1_0",
 *     zone_id="cn-hangzhou-MAZ6",
 *     payment_type="PayAsYouGo",
 *     instance_type="normal")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ApiGateway.Instance("default", new()
 *     {
 *         InstanceName = name,
 *         InstanceSpec = "api.s1.small",
 *         HttpsPolicy = "HTTPS2_TLS1_0",
 *         ZoneId = "cn-hangzhou-MAZ6",
 *         PaymentType = "PayAsYouGo",
 *         InstanceType = "normal",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := apigateway.NewInstance(ctx, "default", &apigateway.InstanceArgs{
 * 			InstanceName: pulumi.String(name),
 * 			InstanceSpec: pulumi.String("api.s1.small"),
 * 			HttpsPolicy:  pulumi.String("HTTPS2_TLS1_0"),
 * 			ZoneId:       pulumi.String("cn-hangzhou-MAZ6"),
 * 			PaymentType:  pulumi.String("PayAsYouGo"),
 * 			InstanceType: pulumi.String("normal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Instance;
 * import com.pulumi.alicloud.apigateway.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceName(name)
 *             .instanceSpec("api.s1.small")
 *             .httpsPolicy("HTTPS2_TLS1_0")
 *             .zoneId("cn-hangzhou-MAZ6")
 *             .paymentType("PayAsYouGo")
 *             .instanceType("normal")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:apigateway:Instance
 *     properties:
 *       instanceName: ${name}
 *       instanceSpec: api.s1.small
 *       httpsPolicy: HTTPS2_TLS1_0
 *       zoneId: cn-hangzhou-MAZ6
 *       paymentType: PayAsYouGo
 *       instanceType: normal
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     cidrBlock: "172.16.0.0/12",
 *     vpcName: name,
 * });
 * const vswitch1 = new alicloud.vpc.Switch("vswitch_1", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.16.0.0/16",
 *     zoneId: "cn-hangzhou-j",
 *     vswitchName: `${name}_1`,
 * });
 * const vswitch2 = new alicloud.vpc.Switch("vswitch_2", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.17.0.0/16",
 *     zoneId: "cn-hangzhou-k",
 *     vswitchName: `${name}_2`,
 * });
 * const securityGroup = new alicloud.ecs.SecurityGroup("security_group", {
 *     vpcId: vpc.id,
 *     name: name,
 * });
 * const vpcIntegrationInstance = new alicloud.apigateway.Instance("vpc_integration_instance", {
 *     instanceName: name,
 *     httpsPolicy: "HTTPS2_TLS1_0",
 *     instanceSpec: "api.s1.small",
 *     instanceType: "vpc_connect",
 *     paymentType: "PayAsYouGo",
 *     userVpcId: vpc.id,
 *     instanceCidr: "192.168.0.0/16",
 *     zoneVswitchSecurityGroups: [
 *         {
 *             zoneId: vswitch1.zoneId,
 *             vswitchId: vswitch1.id,
 *             cidrBlock: vswitch1.cidrBlock,
 *             securityGroup: securityGroup.id,
 *         },
 *         {
 *             zoneId: vswitch2.zoneId,
 *             vswitchId: vswitch2.id,
 *             cidrBlock: vswitch2.cidrBlock,
 *             securityGroup: securityGroup.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * vpc = alicloud.vpc.Network("vpc",
 *     cidr_block="172.16.0.0/12",
 *     vpc_name=name)
 * vswitch1 = alicloud.vpc.Switch("vswitch_1",
 *     vpc_id=vpc.id,
 *     cidr_block="172.16.0.0/16",
 *     zone_id="cn-hangzhou-j",
 *     vswitch_name=f"{name}_1")
 * vswitch2 = alicloud.vpc.Switch("vswitch_2",
 *     vpc_id=vpc.id,
 *     cidr_block="172.17.0.0/16",
 *     zone_id="cn-hangzhou-k",
 *     vswitch_name=f"{name}_2")
 * security_group = alicloud.ecs.SecurityGroup("security_group",
 *     vpc_id=vpc.id,
 *     name=name)
 * vpc_integration_instance = alicloud.apigateway.Instance("vpc_integration_instance",
 *     instance_name=name,
 *     https_policy="HTTPS2_TLS1_0",
 *     instance_spec="api.s1.small",
 *     instance_type="vpc_connect",
 *     payment_type="PayAsYouGo",
 *     user_vpc_id=vpc.id,
 *     instance_cidr="192.168.0.0/16",
 *     zone_vswitch_security_groups=[
 *         {
 *             "zone_id": vswitch1.zone_id,
 *             "vswitch_id": vswitch1.id,
 *             "cidr_block": vswitch1.cidr_block,
 *             "security_group": security_group.id,
 *         },
 *         {
 *             "zone_id": vswitch2.zone_id,
 *             "vswitch_id": vswitch2.id,
 *             "cidr_block": vswitch2.cidr_block,
 *             "security_group": security_group.id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         VpcName = name,
 *     });
 *     var vswitch1 = new AliCloud.Vpc.Switch("vswitch_1", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.16.0.0/16",
 *         ZoneId = "cn-hangzhou-j",
 *         VswitchName = $"{name}_1",
 *     });
 *     var vswitch2 = new AliCloud.Vpc.Switch("vswitch_2", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.17.0.0/16",
 *         ZoneId = "cn-hangzhou-k",
 *         VswitchName = $"{name}_2",
 *     });
 *     var securityGroup = new AliCloud.Ecs.SecurityGroup("security_group", new()
 *     {
 *         VpcId = vpc.Id,
 *         Name = name,
 *     });
 *     var vpcIntegrationInstance = new AliCloud.ApiGateway.Instance("vpc_integration_instance", new()
 *     {
 *         InstanceName = name,
 *         HttpsPolicy = "HTTPS2_TLS1_0",
 *         InstanceSpec = "api.s1.small",
 *         InstanceType = "vpc_connect",
 *         PaymentType = "PayAsYouGo",
 *         UserVpcId = vpc.Id,
 *         InstanceCidr = "192.168.0.0/16",
 *         ZoneVswitchSecurityGroups = new[]
 *         {
 *             new AliCloud.ApiGateway.Inputs.InstanceZoneVswitchSecurityGroupArgs
 *             {
 *                 ZoneId = vswitch1.ZoneId,
 *                 VswitchId = vswitch1.Id,
 *                 CidrBlock = vswitch1.CidrBlock,
 *                 SecurityGroup = securityGroup.Id,
 *             },
 *             new AliCloud.ApiGateway.Inputs.InstanceZoneVswitchSecurityGroupArgs
 *             {
 *                 ZoneId = vswitch2.ZoneId,
 *                 VswitchId = vswitch2.Id,
 *                 CidrBlock = vswitch2.CidrBlock,
 *                 SecurityGroup = securityGroup.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 			VpcName:   pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitch1, err := vpc.NewSwitch(ctx, "vswitch_1", &vpc.SwitchArgs{
 * 			VpcId:       vpc.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/16"),
 * 			ZoneId:      pulumi.String("cn-hangzhou-j"),
 * 			VswitchName: pulumi.Sprintf("%v_1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitch2, err := vpc.NewSwitch(ctx, "vswitch_2", &vpc.SwitchArgs{
 * 			VpcId:       vpc.ID(),
 * 			CidrBlock:   pulumi.String("172.17.0.0/16"),
 * 			ZoneId:      pulumi.String("cn-hangzhou-k"),
 * 			VswitchName: pulumi.Sprintf("%v_2", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		securityGroup, err := ecs.NewSecurityGroup(ctx, "security_group", &ecs.SecurityGroupArgs{
 * 			VpcId: vpc.ID(),
 * 			Name:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewInstance(ctx, "vpc_integration_instance", &apigateway.InstanceArgs{
 * 			InstanceName: pulumi.String(name),
 * 			HttpsPolicy:  pulumi.String("HTTPS2_TLS1_0"),
 * 			InstanceSpec: pulumi.String("api.s1.small"),
 * 			InstanceType: pulumi.String("vpc_connect"),
 * 			PaymentType:  pulumi.String("PayAsYouGo"),
 * 			UserVpcId:    vpc.ID(),
 * 			InstanceCidr: pulumi.String("192.168.0.0/16"),
 * 			ZoneVswitchSecurityGroups: apigateway.InstanceZoneVswitchSecurityGroupArray{
 * 				&apigateway.InstanceZoneVswitchSecurityGroupArgs{
 * 					ZoneId:        vswitch1.ZoneId,
 * 					VswitchId:     vswitch1.ID(),
 * 					CidrBlock:     vswitch1.CidrBlock,
 * 					SecurityGroup: securityGroup.ID(),
 * 				},
 * 				&apigateway.InstanceZoneVswitchSecurityGroupArgs{
 * 					ZoneId:        vswitch2.ZoneId,
 * 					VswitchId:     vswitch2.ID(),
 * 					CidrBlock:     vswitch2.CidrBlock,
 * 					SecurityGroup: securityGroup.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.apigateway.Instance;
 * import com.pulumi.alicloud.apigateway.InstanceArgs;
 * import com.pulumi.alicloud.apigateway.inputs.InstanceZoneVswitchSecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .vpcName(name)
 *             .build());
 *         var vswitch1 = new Switch("vswitch1", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.16.0.0/16")
 *             .zoneId("cn-hangzhou-j")
 *             .vswitchName(String.format("%s_1", name))
 *             .build());
 *         var vswitch2 = new Switch("vswitch2", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.17.0.0/16")
 *             .zoneId("cn-hangzhou-k")
 *             .vswitchName(String.format("%s_2", name))
 *             .build());
 *         var securityGroup = new SecurityGroup("securityGroup", SecurityGroupArgs.builder()
 *             .vpcId(vpc.id())
 *             .name(name)
 *             .build());
 *         var vpcIntegrationInstance = new Instance("vpcIntegrationInstance", InstanceArgs.builder()
 *             .instanceName(name)
 *             .httpsPolicy("HTTPS2_TLS1_0")
 *             .instanceSpec("api.s1.small")
 *             .instanceType("vpc_connect")
 *             .paymentType("PayAsYouGo")
 *             .userVpcId(vpc.id())
 *             .instanceCidr("192.168.0.0/16")
 *             .zoneVswitchSecurityGroups(
 *                 InstanceZoneVswitchSecurityGroupArgs.builder()
 *                     .zoneId(vswitch1.zoneId())
 *                     .vswitchId(vswitch1.id())
 *                     .cidrBlock(vswitch1.cidrBlock())
 *                     .securityGroup(securityGroup.id())
 *                     .build(),
 *                 InstanceZoneVswitchSecurityGroupArgs.builder()
 *                     .zoneId(vswitch2.zoneId())
 *                     .vswitchId(vswitch2.id())
 *                     .cidrBlock(vswitch2.cidrBlock())
 *                     .securityGroup(securityGroup.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       vpcName: ${name}
 *   vswitch1:
 *     type: alicloud:vpc:Switch
 *     name: vswitch_1
 *     properties:
 *       vpcId: ${vpc.id}
 *       cidrBlock: 172.16.0.0/16
 *       zoneId: cn-hangzhou-j
 *       vswitchName: ${name}_1
 *   vswitch2:
 *     type: alicloud:vpc:Switch
 *     name: vswitch_2
 *     properties:
 *       vpcId: ${vpc.id}
 *       cidrBlock: 172.17.0.0/16
 *       zoneId: cn-hangzhou-k
 *       vswitchName: ${name}_2
 *   securityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: security_group
 *     properties:
 *       vpcId: ${vpc.id}
 *       name: ${name}
 *   vpcIntegrationInstance:
 *     type: alicloud:apigateway:Instance
 *     name: vpc_integration_instance
 *     properties:
 *       instanceName: ${name}
 *       httpsPolicy: HTTPS2_TLS1_0
 *       instanceSpec: api.s1.small
 *       instanceType: vpc_connect
 *       paymentType: PayAsYouGo
 *       userVpcId: ${vpc.id}
 *       instanceCidr: 192.168.0.0/16
 *       zoneVswitchSecurityGroups:
 *         - zoneId: ${vswitch1.zoneId}
 *           vswitchId: ${vswitch1.id}
 *           cidrBlock: ${vswitch1.cidrBlock}
 *           securityGroup: ${securityGroup.id}
 *         - zoneId: ${vswitch2.zoneId}
 *           vswitchId: ${vswitch2.id}
 *           cidrBlock: ${vswitch2.cidrBlock}
 *           securityGroup: ${securityGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.apigateway.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * (Available since v1.228.0) The CIDR blocks that can be accessed by the Vpc integration instance.
     */
    public val connectCidrBlocks: Output<String>
        get() = javaResource.connectCidrBlocks().applyValue({ args0 -> args0 })

    /**
     * Creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
     */
    public val deleteVpcIpBlock: Output<String>?
        get() = javaResource.deleteVpcIpBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time of the instance package. Valid values:
     * - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
     * - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
     * When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
     */
    public val duration: Output<Int>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether IPv6 egress capability is enabled.
     */
    public val egressIpv6Enable: Output<Boolean>?
        get() = javaResource.egressIpv6Enable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Https policy.
     */
    public val httpsPolicy: Output<String>
        get() = javaResource.httpsPolicy().applyValue({ args0 -> args0 })

    /**
     * The CIDR block for the instance deployment. Valid values are:
     * - `192.168.0.0/16`.
     * - `172.16.0.0/12`.
     */
    public val instanceCidr: Output<String>
        get() = javaResource.instanceCidr().applyValue({ args0 -> args0 })

    /**
     * Instance name.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * Instance type.
     */
    public val instanceSpec: Output<String>
        get() = javaResource.instanceSpec().applyValue({ args0 -> args0 })

    /**
     * The type of the instance. Valid values are:
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Specifies whether IPv6 ingress capability is enabled.
     */
    public val ipv6Enabled: Output<Boolean>?
        get() = javaResource.ipv6Enabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The payment type of the resource.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
     */
    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Does ipv6 support.
     */
    public val supportIpv6: Output<Boolean>
        get() = javaResource.supportIpv6().applyValue({ args0 -> args0 })

    /**
     * The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
     */
    public val toConnectVpcIpBlock: Output<InstanceToConnectVpcIpBlock>?
        get() = javaResource.toConnectVpcIpBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceToConnectVpcIpBlockToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * User's VpcID.
     */
    public val userVpcId: Output<String>?
        get() = javaResource.userVpcId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the slb of the Vpc supports.
     */
    public val vpcSlbIntranetEnable: Output<Boolean>?
        get() = javaResource.vpcSlbIntranetEnable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The zone where the instance is deployed.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })

    /**
     * Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    public val zoneVswitchSecurityGroups: Output<List<InstanceZoneVswitchSecurityGroup>>?
        get() = javaResource.zoneVswitchSecurityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        instanceZoneVswitchSecurityGroupToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.apigateway.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.apigateway.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
