@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.InstanceArgs.builder
import com.pulumi.alicloud.apigateway.kotlin.inputs.InstanceToConnectVpcIpBlockArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.InstanceToConnectVpcIpBlockArgsBuilder
import com.pulumi.alicloud.apigateway.kotlin.inputs.InstanceZoneVswitchSecurityGroupArgs
import com.pulumi.alicloud.apigateway.kotlin.inputs.InstanceZoneVswitchSecurityGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Api Gateway Instance resource.
 * For information about Api Gateway Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/api-gateway/product-overview/dedicated-instances).
 * > **NOTE:** Available since v1.218.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.apigateway.Instance("default", {
 *     instanceName: name,
 *     instanceSpec: "api.s1.small",
 *     httpsPolicy: "HTTPS2_TLS1_0",
 *     zoneId: "cn-hangzhou-MAZ6",
 *     paymentType: "PayAsYouGo",
 *     instanceType: "normal",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.apigateway.Instance("default",
 *     instance_name=name,
 *     instance_spec="api.s1.small",
 *     https_policy="HTTPS2_TLS1_0",
 *     zone_id="cn-hangzhou-MAZ6",
 *     payment_type="PayAsYouGo",
 *     instance_type="normal")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ApiGateway.Instance("default", new()
 *     {
 *         InstanceName = name,
 *         InstanceSpec = "api.s1.small",
 *         HttpsPolicy = "HTTPS2_TLS1_0",
 *         ZoneId = "cn-hangzhou-MAZ6",
 *         PaymentType = "PayAsYouGo",
 *         InstanceType = "normal",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := apigateway.NewInstance(ctx, "default", &apigateway.InstanceArgs{
 * 			InstanceName: pulumi.String(name),
 * 			InstanceSpec: pulumi.String("api.s1.small"),
 * 			HttpsPolicy:  pulumi.String("HTTPS2_TLS1_0"),
 * 			ZoneId:       pulumi.String("cn-hangzhou-MAZ6"),
 * 			PaymentType:  pulumi.String("PayAsYouGo"),
 * 			InstanceType: pulumi.String("normal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Instance;
 * import com.pulumi.alicloud.apigateway.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .instanceName(name)
 *             .instanceSpec("api.s1.small")
 *             .httpsPolicy("HTTPS2_TLS1_0")
 *             .zoneId("cn-hangzhou-MAZ6")
 *             .paymentType("PayAsYouGo")
 *             .instanceType("normal")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:apigateway:Instance
 *     properties:
 *       instanceName: ${name}
 *       instanceSpec: api.s1.small
 *       httpsPolicy: HTTPS2_TLS1_0
 *       zoneId: cn-hangzhou-MAZ6
 *       paymentType: PayAsYouGo
 *       instanceType: normal
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     cidrBlock: "172.16.0.0/12",
 *     vpcName: name,
 * });
 * const vswitch1 = new alicloud.vpc.Switch("vswitch_1", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.16.0.0/16",
 *     zoneId: "cn-hangzhou-j",
 *     vswitchName: `${name}_1`,
 * });
 * const vswitch2 = new alicloud.vpc.Switch("vswitch_2", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.17.0.0/16",
 *     zoneId: "cn-hangzhou-k",
 *     vswitchName: `${name}_2`,
 * });
 * const securityGroup = new alicloud.ecs.SecurityGroup("security_group", {
 *     vpcId: vpc.id,
 *     name: name,
 * });
 * const vpcIntegrationInstance = new alicloud.apigateway.Instance("vpc_integration_instance", {
 *     instanceName: name,
 *     httpsPolicy: "HTTPS2_TLS1_0",
 *     instanceSpec: "api.s1.small",
 *     instanceType: "vpc_connect",
 *     paymentType: "PayAsYouGo",
 *     userVpcId: vpc.id,
 *     instanceCidr: "192.168.0.0/16",
 *     zoneVswitchSecurityGroups: [
 *         {
 *             zoneId: vswitch1.zoneId,
 *             vswitchId: vswitch1.id,
 *             cidrBlock: vswitch1.cidrBlock,
 *             securityGroup: securityGroup.id,
 *         },
 *         {
 *             zoneId: vswitch2.zoneId,
 *             vswitchId: vswitch2.id,
 *             cidrBlock: vswitch2.cidrBlock,
 *             securityGroup: securityGroup.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * vpc = alicloud.vpc.Network("vpc",
 *     cidr_block="172.16.0.0/12",
 *     vpc_name=name)
 * vswitch1 = alicloud.vpc.Switch("vswitch_1",
 *     vpc_id=vpc.id,
 *     cidr_block="172.16.0.0/16",
 *     zone_id="cn-hangzhou-j",
 *     vswitch_name=f"{name}_1")
 * vswitch2 = alicloud.vpc.Switch("vswitch_2",
 *     vpc_id=vpc.id,
 *     cidr_block="172.17.0.0/16",
 *     zone_id="cn-hangzhou-k",
 *     vswitch_name=f"{name}_2")
 * security_group = alicloud.ecs.SecurityGroup("security_group",
 *     vpc_id=vpc.id,
 *     name=name)
 * vpc_integration_instance = alicloud.apigateway.Instance("vpc_integration_instance",
 *     instance_name=name,
 *     https_policy="HTTPS2_TLS1_0",
 *     instance_spec="api.s1.small",
 *     instance_type="vpc_connect",
 *     payment_type="PayAsYouGo",
 *     user_vpc_id=vpc.id,
 *     instance_cidr="192.168.0.0/16",
 *     zone_vswitch_security_groups=[
 *         {
 *             "zone_id": vswitch1.zone_id,
 *             "vswitch_id": vswitch1.id,
 *             "cidr_block": vswitch1.cidr_block,
 *             "security_group": security_group.id,
 *         },
 *         {
 *             "zone_id": vswitch2.zone_id,
 *             "vswitch_id": vswitch2.id,
 *             "cidr_block": vswitch2.cidr_block,
 *             "security_group": security_group.id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         VpcName = name,
 *     });
 *     var vswitch1 = new AliCloud.Vpc.Switch("vswitch_1", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.16.0.0/16",
 *         ZoneId = "cn-hangzhou-j",
 *         VswitchName = $"{name}_1",
 *     });
 *     var vswitch2 = new AliCloud.Vpc.Switch("vswitch_2", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.17.0.0/16",
 *         ZoneId = "cn-hangzhou-k",
 *         VswitchName = $"{name}_2",
 *     });
 *     var securityGroup = new AliCloud.Ecs.SecurityGroup("security_group", new()
 *     {
 *         VpcId = vpc.Id,
 *         Name = name,
 *     });
 *     var vpcIntegrationInstance = new AliCloud.ApiGateway.Instance("vpc_integration_instance", new()
 *     {
 *         InstanceName = name,
 *         HttpsPolicy = "HTTPS2_TLS1_0",
 *         InstanceSpec = "api.s1.small",
 *         InstanceType = "vpc_connect",
 *         PaymentType = "PayAsYouGo",
 *         UserVpcId = vpc.Id,
 *         InstanceCidr = "192.168.0.0/16",
 *         ZoneVswitchSecurityGroups = new[]
 *         {
 *             new AliCloud.ApiGateway.Inputs.InstanceZoneVswitchSecurityGroupArgs
 *             {
 *                 ZoneId = vswitch1.ZoneId,
 *                 VswitchId = vswitch1.Id,
 *                 CidrBlock = vswitch1.CidrBlock,
 *                 SecurityGroup = securityGroup.Id,
 *             },
 *             new AliCloud.ApiGateway.Inputs.InstanceZoneVswitchSecurityGroupArgs
 *             {
 *                 ZoneId = vswitch2.ZoneId,
 *                 VswitchId = vswitch2.Id,
 *                 CidrBlock = vswitch2.CidrBlock,
 *                 SecurityGroup = securityGroup.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 			VpcName:   pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitch1, err := vpc.NewSwitch(ctx, "vswitch_1", &vpc.SwitchArgs{
 * 			VpcId:       vpc.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/16"),
 * 			ZoneId:      pulumi.String("cn-hangzhou-j"),
 * 			VswitchName: pulumi.Sprintf("%v_1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitch2, err := vpc.NewSwitch(ctx, "vswitch_2", &vpc.SwitchArgs{
 * 			VpcId:       vpc.ID(),
 * 			CidrBlock:   pulumi.String("172.17.0.0/16"),
 * 			ZoneId:      pulumi.String("cn-hangzhou-k"),
 * 			VswitchName: pulumi.Sprintf("%v_2", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		securityGroup, err := ecs.NewSecurityGroup(ctx, "security_group", &ecs.SecurityGroupArgs{
 * 			VpcId: vpc.ID(),
 * 			Name:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewInstance(ctx, "vpc_integration_instance", &apigateway.InstanceArgs{
 * 			InstanceName: pulumi.String(name),
 * 			HttpsPolicy:  pulumi.String("HTTPS2_TLS1_0"),
 * 			InstanceSpec: pulumi.String("api.s1.small"),
 * 			InstanceType: pulumi.String("vpc_connect"),
 * 			PaymentType:  pulumi.String("PayAsYouGo"),
 * 			UserVpcId:    vpc.ID(),
 * 			InstanceCidr: pulumi.String("192.168.0.0/16"),
 * 			ZoneVswitchSecurityGroups: apigateway.InstanceZoneVswitchSecurityGroupArray{
 * 				&apigateway.InstanceZoneVswitchSecurityGroupArgs{
 * 					ZoneId:        vswitch1.ZoneId,
 * 					VswitchId:     vswitch1.ID(),
 * 					CidrBlock:     vswitch1.CidrBlock,
 * 					SecurityGroup: securityGroup.ID(),
 * 				},
 * 				&apigateway.InstanceZoneVswitchSecurityGroupArgs{
 * 					ZoneId:        vswitch2.ZoneId,
 * 					VswitchId:     vswitch2.ID(),
 * 					CidrBlock:     vswitch2.CidrBlock,
 * 					SecurityGroup: securityGroup.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.apigateway.Instance;
 * import com.pulumi.alicloud.apigateway.InstanceArgs;
 * import com.pulumi.alicloud.apigateway.inputs.InstanceZoneVswitchSecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .vpcName(name)
 *             .build());
 *         var vswitch1 = new Switch("vswitch1", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.16.0.0/16")
 *             .zoneId("cn-hangzhou-j")
 *             .vswitchName(String.format("%s_1", name))
 *             .build());
 *         var vswitch2 = new Switch("vswitch2", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.17.0.0/16")
 *             .zoneId("cn-hangzhou-k")
 *             .vswitchName(String.format("%s_2", name))
 *             .build());
 *         var securityGroup = new SecurityGroup("securityGroup", SecurityGroupArgs.builder()
 *             .vpcId(vpc.id())
 *             .name(name)
 *             .build());
 *         var vpcIntegrationInstance = new Instance("vpcIntegrationInstance", InstanceArgs.builder()
 *             .instanceName(name)
 *             .httpsPolicy("HTTPS2_TLS1_0")
 *             .instanceSpec("api.s1.small")
 *             .instanceType("vpc_connect")
 *             .paymentType("PayAsYouGo")
 *             .userVpcId(vpc.id())
 *             .instanceCidr("192.168.0.0/16")
 *             .zoneVswitchSecurityGroups(
 *                 InstanceZoneVswitchSecurityGroupArgs.builder()
 *                     .zoneId(vswitch1.zoneId())
 *                     .vswitchId(vswitch1.id())
 *                     .cidrBlock(vswitch1.cidrBlock())
 *                     .securityGroup(securityGroup.id())
 *                     .build(),
 *                 InstanceZoneVswitchSecurityGroupArgs.builder()
 *                     .zoneId(vswitch2.zoneId())
 *                     .vswitchId(vswitch2.id())
 *                     .cidrBlock(vswitch2.cidrBlock())
 *                     .securityGroup(securityGroup.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       vpcName: ${name}
 *   vswitch1:
 *     type: alicloud:vpc:Switch
 *     name: vswitch_1
 *     properties:
 *       vpcId: ${vpc.id}
 *       cidrBlock: 172.16.0.0/16
 *       zoneId: cn-hangzhou-j
 *       vswitchName: ${name}_1
 *   vswitch2:
 *     type: alicloud:vpc:Switch
 *     name: vswitch_2
 *     properties:
 *       vpcId: ${vpc.id}
 *       cidrBlock: 172.17.0.0/16
 *       zoneId: cn-hangzhou-k
 *       vswitchName: ${name}_2
 *   securityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: security_group
 *     properties:
 *       vpcId: ${vpc.id}
 *       name: ${name}
 *   vpcIntegrationInstance:
 *     type: alicloud:apigateway:Instance
 *     name: vpc_integration_instance
 *     properties:
 *       instanceName: ${name}
 *       httpsPolicy: HTTPS2_TLS1_0
 *       instanceSpec: api.s1.small
 *       instanceType: vpc_connect
 *       paymentType: PayAsYouGo
 *       userVpcId: ${vpc.id}
 *       instanceCidr: 192.168.0.0/16
 *       zoneVswitchSecurityGroups:
 *         - zoneId: ${vswitch1.zoneId}
 *           vswitchId: ${vswitch1.id}
 *           cidrBlock: ${vswitch1.cidrBlock}
 *           securityGroup: ${securityGroup.id}
 *         - zoneId: ${vswitch2.zoneId}
 *           vswitchId: ${vswitch2.id}
 *           cidrBlock: ${vswitch2.cidrBlock}
 *           securityGroup: ${securityGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/instance:Instance example <id>
 * ```
 * @property deleteVpcIpBlock Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
 * @property duration The time of the instance package. Valid values:
 * - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
 * - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
 * When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
 * @property egressIpv6Enable Specifies whether IPv6 egress capability is enabled.
 * @property httpsPolicy Https policy.
 * @property instanceCidr The CIDR block for the instance deployment. Valid values are:
 * - `192.168.0.0/16`.
 * - `172.16.0.0/12`.
 * @property instanceName Instance name.
 * @property instanceSpec Instance type.
 * @property instanceType The type of the instance. Valid values are:
 * @property ipv6Enabled Specifies whether IPv6 ingress capability is enabled.
 * @property paymentType The payment type of the resource.
 * @property pricingCycle The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
 * @property toConnectVpcIpBlock The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
 * @property userVpcId User's VpcID.
 * @property vpcSlbIntranetEnable Whether the slb of the Vpc supports.
 * @property zoneId The zone where the instance is deployed.
 * @property zoneVswitchSecurityGroups Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
 */
public data class InstanceArgs(
    public val deleteVpcIpBlock: Output<String>? = null,
    public val duration: Output<Int>? = null,
    public val egressIpv6Enable: Output<Boolean>? = null,
    public val httpsPolicy: Output<String>? = null,
    public val instanceCidr: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceSpec: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val ipv6Enabled: Output<Boolean>? = null,
    public val paymentType: Output<String>? = null,
    public val pricingCycle: Output<String>? = null,
    public val toConnectVpcIpBlock: Output<InstanceToConnectVpcIpBlockArgs>? = null,
    public val userVpcId: Output<String>? = null,
    public val vpcSlbIntranetEnable: Output<Boolean>? = null,
    public val zoneId: Output<String>? = null,
    public val zoneVswitchSecurityGroups: Output<List<InstanceZoneVswitchSecurityGroupArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.InstanceArgs =
        com.pulumi.alicloud.apigateway.InstanceArgs.builder()
            .deleteVpcIpBlock(deleteVpcIpBlock?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .egressIpv6Enable(egressIpv6Enable?.applyValue({ args0 -> args0 }))
            .httpsPolicy(httpsPolicy?.applyValue({ args0 -> args0 }))
            .instanceCidr(instanceCidr?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceSpec(instanceSpec?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .ipv6Enabled(ipv6Enabled?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .toConnectVpcIpBlock(
                toConnectVpcIpBlock?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userVpcId(userVpcId?.applyValue({ args0 -> args0 }))
            .vpcSlbIntranetEnable(vpcSlbIntranetEnable?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 }))
            .zoneVswitchSecurityGroups(
                zoneVswitchSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var deleteVpcIpBlock: Output<String>? = null

    private var duration: Output<Int>? = null

    private var egressIpv6Enable: Output<Boolean>? = null

    private var httpsPolicy: Output<String>? = null

    private var instanceCidr: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceSpec: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var ipv6Enabled: Output<Boolean>? = null

    private var paymentType: Output<String>? = null

    private var pricingCycle: Output<String>? = null

    private var toConnectVpcIpBlock: Output<InstanceToConnectVpcIpBlockArgs>? = null

    private var userVpcId: Output<String>? = null

    private var vpcSlbIntranetEnable: Output<Boolean>? = null

    private var zoneId: Output<String>? = null

    private var zoneVswitchSecurityGroups: Output<List<InstanceZoneVswitchSecurityGroupArgs>>? = null

    /**
     * @param value Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
     */
    @JvmName("tqfyjelkxacvuyqc")
    public suspend fun deleteVpcIpBlock(`value`: Output<String>) {
        this.deleteVpcIpBlock = value
    }

    /**
     * @param value The time of the instance package. Valid values:
     * - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
     * - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
     * When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
     */
    @JvmName("dcbeawtdecfsjynm")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value Specifies whether IPv6 egress capability is enabled.
     */
    @JvmName("mgilavplbbdydrvf")
    public suspend fun egressIpv6Enable(`value`: Output<Boolean>) {
        this.egressIpv6Enable = value
    }

    /**
     * @param value Https policy.
     */
    @JvmName("yfvtoaxouknvqwsq")
    public suspend fun httpsPolicy(`value`: Output<String>) {
        this.httpsPolicy = value
    }

    /**
     * @param value The CIDR block for the instance deployment. Valid values are:
     * - `192.168.0.0/16`.
     * - `172.16.0.0/12`.
     */
    @JvmName("lvnvqsagldqukruv")
    public suspend fun instanceCidr(`value`: Output<String>) {
        this.instanceCidr = value
    }

    /**
     * @param value Instance name.
     */
    @JvmName("itxrtetfbfqxvpim")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Instance type.
     */
    @JvmName("jbkklqexkmrylbbp")
    public suspend fun instanceSpec(`value`: Output<String>) {
        this.instanceSpec = value
    }

    /**
     * @param value The type of the instance. Valid values are:
     */
    @JvmName("pbtwdalqlpaquppl")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Specifies whether IPv6 ingress capability is enabled.
     */
    @JvmName("unvhqevidxcmevqg")
    public suspend fun ipv6Enabled(`value`: Output<Boolean>) {
        this.ipv6Enabled = value
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("fqkiyotsavgggwbd")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
     */
    @JvmName("pkxfdvyivhfmkpxf")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
     */
    @JvmName("pnueuuooqumeemkd")
    public suspend fun toConnectVpcIpBlock(`value`: Output<InstanceToConnectVpcIpBlockArgs>) {
        this.toConnectVpcIpBlock = value
    }

    /**
     * @param value User's VpcID.
     */
    @JvmName("qsndlnqhjsphmrny")
    public suspend fun userVpcId(`value`: Output<String>) {
        this.userVpcId = value
    }

    /**
     * @param value Whether the slb of the Vpc supports.
     */
    @JvmName("mwgivxvadhovdshh")
    public suspend fun vpcSlbIntranetEnable(`value`: Output<Boolean>) {
        this.vpcSlbIntranetEnable = value
    }

    /**
     * @param value The zone where the instance is deployed.
     */
    @JvmName("qvmygnrgettrspaj")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    @JvmName("qgpuiowmvgalcwdw")
    public suspend fun zoneVswitchSecurityGroups(`value`: Output<List<InstanceZoneVswitchSecurityGroupArgs>>) {
        this.zoneVswitchSecurityGroups = value
    }

    @JvmName("gjuwbhrycodxpjoy")
    public suspend fun zoneVswitchSecurityGroups(vararg values: Output<InstanceZoneVswitchSecurityGroupArgs>) {
        this.zoneVswitchSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    @JvmName("vlyqtrfspinoafbw")
    public suspend fun zoneVswitchSecurityGroups(values: List<Output<InstanceZoneVswitchSecurityGroupArgs>>) {
        this.zoneVswitchSecurityGroups = Output.all(values)
    }

    /**
     * @param value Indicates whether to delete the IP block that the VPC can access, conflict with `to_connect_vpc_ip_block`.
     */
    @JvmName("ufpmdbncjaoevqco")
    public suspend fun deleteVpcIpBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteVpcIpBlock = mapped
    }

    /**
     * @param value The time of the instance package. Valid values:
     * - PricingCycle is **Month**, indicating monthly payment. The value range is **1** to **9**.
     * - PricingCycle is **Year**, indicating annual payment. The value range is **1** to **3**.
     * When the value of> ChargeType is **PrePaid**, this parameter is available and must be passed in.
     */
    @JvmName("rmnisgfddafgaask")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Specifies whether IPv6 egress capability is enabled.
     */
    @JvmName("piopfxxahlfimgqh")
    public suspend fun egressIpv6Enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressIpv6Enable = mapped
    }

    /**
     * @param value Https policy.
     */
    @JvmName("oxqkuegwmfvngvft")
    public suspend fun httpsPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPolicy = mapped
    }

    /**
     * @param value The CIDR block for the instance deployment. Valid values are:
     * - `192.168.0.0/16`.
     * - `172.16.0.0/12`.
     */
    @JvmName("ekxeoxwdgftglivx")
    public suspend fun instanceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCidr = mapped
    }

    /**
     * @param value Instance name.
     */
    @JvmName("ofesbeqstjeyqswm")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Instance type.
     */
    @JvmName("oobcfrkgihehyapd")
    public suspend fun instanceSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceSpec = mapped
    }

    /**
     * @param value The type of the instance. Valid values are:
     */
    @JvmName("apbskpbndmhnmyke")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Specifies whether IPv6 ingress capability is enabled.
     */
    @JvmName("jfbvtbadgmfpkyai")
    public suspend fun ipv6Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Enabled = mapped
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("vanbeugtcxcvxjpy")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The subscription instance is of the subscription year or month type. This parameter is required when the Payment type is PrePaid. The value range is as follows:
     */
    @JvmName("dcvhlaeloujnfpnf")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
     */
    @JvmName("wplqghfxmuiihggi")
    public suspend fun toConnectVpcIpBlock(`value`: InstanceToConnectVpcIpBlockArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toConnectVpcIpBlock = mapped
    }

    /**
     * @param argument The additional IP block that the VPC integration instance can access, conflict with `delete_vpc_ip_block`. See `to_connect_vpc_ip_block` below.
     */
    @JvmName("voyffiqillakhmcv")
    public suspend fun toConnectVpcIpBlock(argument: suspend InstanceToConnectVpcIpBlockArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceToConnectVpcIpBlockArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.toConnectVpcIpBlock = mapped
    }

    /**
     * @param value User's VpcID.
     */
    @JvmName("tpwqrnrdnxeuvjxe")
    public suspend fun userVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userVpcId = mapped
    }

    /**
     * @param value Whether the slb of the Vpc supports.
     */
    @JvmName("yagodfrsqlvnvqhj")
    public suspend fun vpcSlbIntranetEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSlbIntranetEnable = mapped
    }

    /**
     * @param value The zone where the instance is deployed.
     */
    @JvmName("efpjmcmkuefjwcgh")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    /**
     * @param value Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    @JvmName("fvyxhehncsjqcnbl")
    public suspend fun zoneVswitchSecurityGroups(`value`: List<InstanceZoneVswitchSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneVswitchSecurityGroups = mapped
    }

    /**
     * @param argument Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    @JvmName("pubmvktwkjqgeqht")
    public suspend fun zoneVswitchSecurityGroups(argument: List<suspend InstanceZoneVswitchSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceZoneVswitchSecurityGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneVswitchSecurityGroups = mapped
    }

    /**
     * @param argument Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    @JvmName("nppntckhlqsqevju")
    public suspend fun zoneVswitchSecurityGroups(vararg argument: suspend InstanceZoneVswitchSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceZoneVswitchSecurityGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneVswitchSecurityGroups = mapped
    }

    /**
     * @param argument Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    @JvmName("sisuysbhmtsccjri")
    public suspend fun zoneVswitchSecurityGroups(argument: suspend InstanceZoneVswitchSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceZoneVswitchSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.zoneVswitchSecurityGroups = mapped
    }

    /**
     * @param values Network configuration details for Vpc integration instance which includes the availability zone, VSwitch, and security group information. See `zone_vswitch_security_group` below.
     */
    @JvmName("fmdypoqdwwqqvmqs")
    public suspend fun zoneVswitchSecurityGroups(vararg values: InstanceZoneVswitchSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneVswitchSecurityGroups = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        deleteVpcIpBlock = deleteVpcIpBlock,
        duration = duration,
        egressIpv6Enable = egressIpv6Enable,
        httpsPolicy = httpsPolicy,
        instanceCidr = instanceCidr,
        instanceName = instanceName,
        instanceSpec = instanceSpec,
        instanceType = instanceType,
        ipv6Enabled = ipv6Enabled,
        paymentType = paymentType,
        pricingCycle = pricingCycle,
        toConnectVpcIpBlock = toConnectVpcIpBlock,
        userVpcId = userVpcId,
        vpcSlbIntranetEnable = vpcSlbIntranetEnable,
        zoneId = zoneId,
        zoneVswitchSecurityGroups = zoneVswitchSecurityGroups,
    )
}
