@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Model].
 */
@PulumiTagMarker
public class ModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelArgs = ModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelArgsBuilder.() -> Unit) {
        val builder = ModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Model {
        val builtJavaResource = com.pulumi.alicloud.apigateway.Model(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Model(builtJavaResource)
    }
}

/**
 * Provides a Api Gateway Model resource.
 * For information about Api Gateway Model and how to use it, see [What is Model](https://www.alibabacloud.com/help/en/api-gateway/latest/api-cloudapi-2016-07-14-createmodel).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.apigateway.Group("default", {
 *     name: "example_value",
 *     description: "example_value",
 * });
 * const defaultModel = new alicloud.apigateway.Model("default", {
 *     groupId: _default.id,
 *     modelName: "example_value",
 *     schema: "{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}",
 *     description: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.apigateway.Group("default",
 *     name="example_value",
 *     description="example_value")
 * default_model = alicloud.apigateway.Model("default",
 *     group_id=default.id,
 *     model_name="example_value",
 *     schema="{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}",
 *     description="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ApiGateway.Group("default", new()
 *     {
 *         Name = "example_value",
 *         Description = "example_value",
 *     });
 *     var defaultModel = new AliCloud.ApiGateway.Model("default", new()
 *     {
 *         GroupId = @default.Id,
 *         ModelName = "example_value",
 *         Schema = "{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}",
 *         Description = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewGroup(ctx, "default", &apigateway.GroupArgs{
 * 			Name:        pulumi.String("example_value"),
 * 			Description: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewModel(ctx, "default", &apigateway.ModelArgs{
 * 			GroupId:     _default.ID(),
 * 			ModelName:   pulumi.String("example_value"),
 * 			Schema:      pulumi.String("{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}"),
 * 			Description: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Group;
 * import com.pulumi.alicloud.apigateway.GroupArgs;
 * import com.pulumi.alicloud.apigateway.Model;
 * import com.pulumi.alicloud.apigateway.ModelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Group("default", GroupArgs.builder()
 *             .name("example_value")
 *             .description("example_value")
 *             .build());
 *         var defaultModel = new Model("defaultModel", ModelArgs.builder()
 *             .groupId(default_.id())
 *             .modelName("example_value")
 *             .schema("{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}")
 *             .description("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:apigateway:Group
 *     properties:
 *       name: example_value
 *       description: example_value
 *   defaultModel:
 *     type: alicloud:apigateway:Model
 *     name: default
 *     properties:
 *       groupId: ${default.id}
 *       modelName: example_value
 *       schema: '{"type":"object","properties":{"id":{"format":"int64","maximum":100,"exclusiveMaximum":true,"type":"integer"},"name":{"maxLength":10,"type":"string"}}}'
 *       description: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Model can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/model:Model example <group_id>:<model_name>
 * ```
 */
public class Model internal constructor(
    override val javaResource: com.pulumi.alicloud.apigateway.Model,
) : KotlinCustomResource(javaResource, ModelMapper) {
    /**
     * The description of the model.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The group of the model belongs to.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The name of the model.
     */
    public val modelName: Output<String>
        get() = javaResource.modelName().applyValue({ args0 -> args0 })

    /**
     * The schema of the model.
     */
    public val schema: Output<String>
        get() = javaResource.schema().applyValue({ args0 -> args0 })
}

public object ModelMapper : ResourceMapper<Model> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.apigateway.Model::class == javaResource::class

    override fun map(javaResource: Resource): Model = Model(
        javaResource as
            com.pulumi.alicloud.apigateway.Model,
    )
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Model].
 */
public suspend fun model(name: String, block: suspend ModelResourceBuilder.() -> Unit): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 */
public fun model(name: String): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
