@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.ModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Api Gateway Model resource.
 * For information about Api Gateway Model and how to use it, see [What is Model](https://www.alibabacloud.com/help/en/api-gateway/latest/api-cloudapi-2016-07-14-createmodel).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.apigateway.Group("default", {
 *     name: "example_value",
 *     description: "example_value",
 * });
 * const defaultModel = new alicloud.apigateway.Model("default", {
 *     groupId: _default.id,
 *     modelName: "example_value",
 *     schema: "{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}",
 *     description: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.apigateway.Group("default",
 *     name="example_value",
 *     description="example_value")
 * default_model = alicloud.apigateway.Model("default",
 *     group_id=default.id,
 *     model_name="example_value",
 *     schema="{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}",
 *     description="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ApiGateway.Group("default", new()
 *     {
 *         Name = "example_value",
 *         Description = "example_value",
 *     });
 *     var defaultModel = new AliCloud.ApiGateway.Model("default", new()
 *     {
 *         GroupId = @default.Id,
 *         ModelName = "example_value",
 *         Schema = "{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}",
 *         Description = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewGroup(ctx, "default", &apigateway.GroupArgs{
 * 			Name:        pulumi.String("example_value"),
 * 			Description: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewModel(ctx, "default", &apigateway.ModelArgs{
 * 			GroupId:     _default.ID(),
 * 			ModelName:   pulumi.String("example_value"),
 * 			Schema:      pulumi.String("{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}"),
 * 			Description: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Group;
 * import com.pulumi.alicloud.apigateway.GroupArgs;
 * import com.pulumi.alicloud.apigateway.Model;
 * import com.pulumi.alicloud.apigateway.ModelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Group("default", GroupArgs.builder()
 *             .name("example_value")
 *             .description("example_value")
 *             .build());
 *         var defaultModel = new Model("defaultModel", ModelArgs.builder()
 *             .groupId(default_.id())
 *             .modelName("example_value")
 *             .schema("{\"type\":\"object\",\"properties\":{\"id\":{\"format\":\"int64\",\"maximum\":100,\"exclusiveMaximum\":true,\"type\":\"integer\"},\"name\":{\"maxLength\":10,\"type\":\"string\"}}}")
 *             .description("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:apigateway:Group
 *     properties:
 *       name: example_value
 *       description: example_value
 *   defaultModel:
 *     type: alicloud:apigateway:Model
 *     name: default
 *     properties:
 *       groupId: ${default.id}
 *       modelName: example_value
 *       schema: '{"type":"object","properties":{"id":{"format":"int64","maximum":100,"exclusiveMaximum":true,"type":"integer"},"name":{"maxLength":10,"type":"string"}}}'
 *       description: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Model can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/model:Model example <group_id>:<model_name>
 * ```
 * @property description The description of the model.
 * @property groupId The group of the model belongs to.
 * @property modelName The name of the model.
 * @property schema The schema of the model.
 */
public data class ModelArgs(
    public val description: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val modelName: Output<String>? = null,
    public val schema: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.ModelArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.ModelArgs =
        com.pulumi.alicloud.apigateway.ModelArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelArgs].
 */
@PulumiTagMarker
public class ModelArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var groupId: Output<String>? = null

    private var modelName: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value The description of the model.
     */
    @JvmName("touhkrxqwcngptbq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The group of the model belongs to.
     */
    @JvmName("ptjpbltitdddhsng")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the model.
     */
    @JvmName("kfdqywbxrqqjqphu")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value The schema of the model.
     */
    @JvmName("pgesopcbmlpvkhsq")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value The description of the model.
     */
    @JvmName("lebvmhchpgjpyviy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The group of the model belongs to.
     */
    @JvmName("tvtxbqtxaqixriab")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the model.
     */
    @JvmName("sstbaksbgwtpubyw")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value The schema of the model.
     */
    @JvmName("toctakbhuuclaspu")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): ModelArgs = ModelArgs(
        description = description,
        groupId = groupId,
        modelName = modelName,
        schema = schema,
    )
}
