@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Plugin].
 */
@PulumiTagMarker
public class PluginResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PluginArgs = PluginArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PluginArgsBuilder.() -> Unit) {
        val builder = PluginArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Plugin {
        val builtJavaResource = com.pulumi.alicloud.apigateway.Plugin(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Plugin(builtJavaResource)
    }
}

/**
 * Provides a Api Gateway Plugin resource.
 * For information about Api Gateway Plugin and how to use it, see [What is Plugin](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createplugin).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.apigateway.Plugin("default", {
 *     description: name,
 *     pluginName: name,
 *     pluginData: JSON.stringify({
 *         routes: [
 *             {
 *                 name: "Vip",
 *                 condition: "$CaAppId = 123456",
 *                 backend: {
 *                     type: "HTTP-VPC",
 *                     vpcAccessName: "slbAccessForVip",
 *                 },
 *             },
 *             {
 *                 name: "MockForOldClient",
 *                 condition: "$ClientVersion < '2.0.5'",
 *                 backend: {
 *                     type: "MOCK",
 *                     statusCode: 400,
 *                     mockBody: "This version is not supported!!!",
 *                 },
 *             },
 *             {
 *                 name: "BlueGreenPercent05",
 *                 condition: "1 = 1",
 *                 backend: {
 *                     type: "HTTP",
 *                     address: "https://beta-version.api.foo.com",
 *                 },
 *                 "constant-parameters": [{
 *                     name: "x-route-blue-green",
 *                     location: "header",
 *                     value: "route-blue-green",
 *                 }],
 *             },
 *         ],
 *     }),
 *     pluginType: "routing",
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.apigateway.Plugin("default",
 *     description=name,
 *     plugin_name=name,
 *     plugin_data=json.dumps({
 *         "routes": [
 *             {
 *                 "name": "Vip",
 *                 "condition": "$CaAppId = 123456",
 *                 "backend": {
 *                     "type": "HTTP-VPC",
 *                     "vpcAccessName": "slbAccessForVip",
 *                 },
 *             },
 *             {
 *                 "name": "MockForOldClient",
 *                 "condition": "$ClientVersion < '2.0.5'",
 *                 "backend": {
 *                     "type": "MOCK",
 *                     "statusCode": 400,
 *                     "mockBody": "This version is not supported!!!",
 *                 },
 *             },
 *             {
 *                 "name": "BlueGreenPercent05",
 *                 "condition": "1 = 1",
 *                 "backend": {
 *                     "type": "HTTP",
 *                     "address": "https://beta-version.api.foo.com",
 *                 },
 *                 "constant-parameters": [{
 *                     "name": "x-route-blue-green",
 *                     "location": "header",
 *                     "value": "route-blue-green",
 *                 }],
 *             },
 *         ],
 *     }),
 *     plugin_type="routing")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.ApiGateway.Plugin("default", new()
 *     {
 *         Description = name,
 *         PluginName = name,
 *         PluginData = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["routes"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "Vip",
 *                     ["condition"] = "$CaAppId = 123456",
 *                     ["backend"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "HTTP-VPC",
 *                         ["vpcAccessName"] = "slbAccessForVip",
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "MockForOldClient",
 *                     ["condition"] = "$ClientVersion < '2.0.5'",
 *                     ["backend"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "MOCK",
 *                         ["statusCode"] = 400,
 *                         ["mockBody"] = "This version is not supported!!!",
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "BlueGreenPercent05",
 *                     ["condition"] = "1 = 1",
 *                     ["backend"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "HTTP",
 *                         ["address"] = "https://beta-version.api.foo.com",
 *                     },
 *                     ["constant-parameters"] = new[]
 *                     {
 *                         new Dictionary<string, object?>
 *                         {
 *                             ["name"] = "x-route-blue-green",
 *                             ["location"] = "header",
 *                             ["value"] = "route-blue-green",
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *         PluginType = "routing",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"routes": []interface{}{
 * 				map[string]interface{}{
 * 					"name":      "Vip",
 * 					"condition": "$CaAppId = 123456",
 * 					"backend": map[string]interface{}{
 * 						"type":          "HTTP-VPC",
 * 						"vpcAccessName": "slbAccessForVip",
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"name":      "MockForOldClient",
 * 					"condition": "$ClientVersion < '2.0.5'",
 * 					"backend": map[string]interface{}{
 * 						"type":       "MOCK",
 * 						"statusCode": 400,
 * 						"mockBody":   "This version is not supported!!!",
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"name":      "BlueGreenPercent05",
 * 					"condition": "1 = 1",
 * 					"backend": map[string]interface{}{
 * 						"type":    "HTTP",
 * 						"address": "https://beta-version.api.foo.com",
 * 					},
 * 					"constant-parameters": []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"name":     "x-route-blue-green",
 * 							"location": "header",
 * 							"value":    "route-blue-green",
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = apigateway.NewPlugin(ctx, "default", &apigateway.PluginArgs{
 * 			Description: pulumi.String(name),
 * 			PluginName:  pulumi.String(name),
 * 			PluginData:  pulumi.String(json0),
 * 			PluginType:  pulumi.String("routing"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Plugin;
 * import com.pulumi.alicloud.apigateway.PluginArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new Plugin("default", PluginArgs.builder()
 *             .description(name)
 *             .pluginName(name)
 *             .pluginData(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("routes", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("name", "Vip"),
 *                             jsonProperty("condition", "$CaAppId = 123456"),
 *                             jsonProperty("backend", jsonObject(
 *                                 jsonProperty("type", "HTTP-VPC"),
 *                                 jsonProperty("vpcAccessName", "slbAccessForVip")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("name", "MockForOldClient"),
 *                             jsonProperty("condition", "$ClientVersion < '2.0.5'"),
 *                             jsonProperty("backend", jsonObject(
 *                                 jsonProperty("type", "MOCK"),
 *                                 jsonProperty("statusCode", 400),
 *                                 jsonProperty("mockBody", "This version is not supported!!!")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("name", "BlueGreenPercent05"),
 *                             jsonProperty("condition", "1 = 1"),
 *                             jsonProperty("backend", jsonObject(
 *                                 jsonProperty("type", "HTTP"),
 *                                 jsonProperty("address", "https://beta-version.api.foo.com")
 *                             )),
 *                             jsonProperty("constant-parameters", jsonArray(jsonObject(
 *                                 jsonProperty("name", "x-route-blue-green"),
 *                                 jsonProperty("location", "header"),
 *                                 jsonProperty("value", "route-blue-green")
 *                             )))
 *                         )
 *                     ))
 *                 )))
 *             .pluginType("routing")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:apigateway:Plugin
 *     properties:
 *       description: ${name}
 *       pluginName: ${name}
 *       pluginData:
 *         fn::toJSON:
 *           routes:
 *             - name: Vip
 *               condition: $CaAppId = 123456
 *               backend:
 *                 type: HTTP-VPC
 *                 vpcAccessName: slbAccessForVip
 *             - name: MockForOldClient
 *               condition: $ClientVersion < '2.0.5'
 *               backend:
 *                 type: MOCK
 *                 statusCode: 400
 *                 mockBody: This version is not supported!!!
 *             - name: BlueGreenPercent05
 *               condition: 1 = 1
 *               backend:
 *                 type: HTTP
 *                 address: https://beta-version.api.foo.com
 *               constant-parameters:
 *                 - name: x-route-blue-green
 *                   location: header
 *                   value: route-blue-green
 *       pluginType: routing
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Plugin can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/plugin:Plugin example <id>
 * ```
 */
public class Plugin internal constructor(
    override val javaResource: com.pulumi.alicloud.apigateway.Plugin,
) : KotlinCustomResource(javaResource, PluginMapper) {
    /**
     * Create time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the plug-in, which cannot exceed 200 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
     */
    public val pluginData: Output<String>
        get() = javaResource.pluginData().applyValue({ args0 -> args0 })

    /**
     * The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
     */
    public val pluginName: Output<String>
        get() = javaResource.pluginName().applyValue({ args0 -> args0 })

    /**
     * The type of the plug-in. Valid values:
     * - "trafficControl"
     * - "ipControl"
     * - "backendSignature"
     * - "jwtAuth"
     * - "basicAuth"
     * - "cors"
     * - "caching"
     * - "routing"
     * - "accessControl"
     * - "errorMapping"
     * - "circuitBreaker"
     * - "remoteAuth"
     * - "logMask"
     * - "transformer".
     */
    public val pluginType: Output<String>
        get() = javaResource.pluginType().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object PluginMapper : ResourceMapper<Plugin> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.apigateway.Plugin::class == javaResource::class

    override fun map(javaResource: Resource): Plugin = Plugin(
        javaResource as
            com.pulumi.alicloud.apigateway.Plugin,
    )
}

/**
 * @see [Plugin].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Plugin].
 */
public suspend fun plugin(name: String, block: suspend PluginResourceBuilder.() -> Unit): Plugin {
    val builder = PluginResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Plugin].
 * @param name The _unique_ name of the resulting resource.
 */
public fun plugin(name: String): Plugin {
    val builder = PluginResourceBuilder()
    builder.name(name)
    return builder.build()
}
