@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin

import com.pulumi.alicloud.apigateway.PluginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Api Gateway Plugin resource.
 * For information about Api Gateway Plugin and how to use it, see [What is Plugin](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createplugin).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const _default = new alicloud.apigateway.Plugin("default", {
 *     description: name,
 *     pluginName: name,
 *     pluginData: JSON.stringify({
 *         routes: [
 *             {
 *                 name: "Vip",
 *                 condition: "$CaAppId = 123456",
 *                 backend: {
 *                     type: "HTTP-VPC",
 *                     vpcAccessName: "slbAccessForVip",
 *                 },
 *             },
 *             {
 *                 name: "MockForOldClient",
 *                 condition: "$ClientVersion < '2.0.5'",
 *                 backend: {
 *                     type: "MOCK",
 *                     statusCode: 400,
 *                     mockBody: "This version is not supported!!!",
 *                 },
 *             },
 *             {
 *                 name: "BlueGreenPercent05",
 *                 condition: "1 = 1",
 *                 backend: {
 *                     type: "HTTP",
 *                     address: "https://beta-version.api.foo.com",
 *                 },
 *                 "constant-parameters": [{
 *                     name: "x-route-blue-green",
 *                     location: "header",
 *                     value: "route-blue-green",
 *                 }],
 *             },
 *         ],
 *     }),
 *     pluginType: "routing",
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.apigateway.Plugin("default",
 *     description=name,
 *     plugin_name=name,
 *     plugin_data=json.dumps({
 *         "routes": [
 *             {
 *                 "name": "Vip",
 *                 "condition": "$CaAppId = 123456",
 *                 "backend": {
 *                     "type": "HTTP-VPC",
 *                     "vpcAccessName": "slbAccessForVip",
 *                 },
 *             },
 *             {
 *                 "name": "MockForOldClient",
 *                 "condition": "$ClientVersion < '2.0.5'",
 *                 "backend": {
 *                     "type": "MOCK",
 *                     "statusCode": 400,
 *                     "mockBody": "This version is not supported!!!",
 *                 },
 *             },
 *             {
 *                 "name": "BlueGreenPercent05",
 *                 "condition": "1 = 1",
 *                 "backend": {
 *                     "type": "HTTP",
 *                     "address": "https://beta-version.api.foo.com",
 *                 },
 *                 "constant-parameters": [{
 *                     "name": "x-route-blue-green",
 *                     "location": "header",
 *                     "value": "route-blue-green",
 *                 }],
 *             },
 *         ],
 *     }),
 *     plugin_type="routing")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = new AliCloud.ApiGateway.Plugin("default", new()
 *     {
 *         Description = name,
 *         PluginName = name,
 *         PluginData = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["routes"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "Vip",
 *                     ["condition"] = "$CaAppId = 123456",
 *                     ["backend"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "HTTP-VPC",
 *                         ["vpcAccessName"] = "slbAccessForVip",
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "MockForOldClient",
 *                     ["condition"] = "$ClientVersion < '2.0.5'",
 *                     ["backend"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "MOCK",
 *                         ["statusCode"] = 400,
 *                         ["mockBody"] = "This version is not supported!!!",
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "BlueGreenPercent05",
 *                     ["condition"] = "1 = 1",
 *                     ["backend"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "HTTP",
 *                         ["address"] = "https://beta-version.api.foo.com",
 *                     },
 *                     ["constant-parameters"] = new[]
 *                     {
 *                         new Dictionary<string, object?>
 *                         {
 *                             ["name"] = "x-route-blue-green",
 *                             ["location"] = "header",
 *                             ["value"] = "route-blue-green",
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *         PluginType = "routing",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"routes": []interface{}{
 * 				map[string]interface{}{
 * 					"name":      "Vip",
 * 					"condition": "$CaAppId = 123456",
 * 					"backend": map[string]interface{}{
 * 						"type":          "HTTP-VPC",
 * 						"vpcAccessName": "slbAccessForVip",
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"name":      "MockForOldClient",
 * 					"condition": "$ClientVersion < '2.0.5'",
 * 					"backend": map[string]interface{}{
 * 						"type":       "MOCK",
 * 						"statusCode": 400,
 * 						"mockBody":   "This version is not supported!!!",
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"name":      "BlueGreenPercent05",
 * 					"condition": "1 = 1",
 * 					"backend": map[string]interface{}{
 * 						"type":    "HTTP",
 * 						"address": "https://beta-version.api.foo.com",
 * 					},
 * 					"constant-parameters": []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"name":     "x-route-blue-green",
 * 							"location": "header",
 * 							"value":    "route-blue-green",
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = apigateway.NewPlugin(ctx, "default", &apigateway.PluginArgs{
 * 			Description: pulumi.String(name),
 * 			PluginName:  pulumi.String(name),
 * 			PluginData:  pulumi.String(json0),
 * 			PluginType:  pulumi.String("routing"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.apigateway.Plugin;
 * import com.pulumi.alicloud.apigateway.PluginArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         var default_ = new Plugin("default", PluginArgs.builder()
 *             .description(name)
 *             .pluginName(name)
 *             .pluginData(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("routes", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("name", "Vip"),
 *                             jsonProperty("condition", "$CaAppId = 123456"),
 *                             jsonProperty("backend", jsonObject(
 *                                 jsonProperty("type", "HTTP-VPC"),
 *                                 jsonProperty("vpcAccessName", "slbAccessForVip")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("name", "MockForOldClient"),
 *                             jsonProperty("condition", "$ClientVersion < '2.0.5'"),
 *                             jsonProperty("backend", jsonObject(
 *                                 jsonProperty("type", "MOCK"),
 *                                 jsonProperty("statusCode", 400),
 *                                 jsonProperty("mockBody", "This version is not supported!!!")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("name", "BlueGreenPercent05"),
 *                             jsonProperty("condition", "1 = 1"),
 *                             jsonProperty("backend", jsonObject(
 *                                 jsonProperty("type", "HTTP"),
 *                                 jsonProperty("address", "https://beta-version.api.foo.com")
 *                             )),
 *                             jsonProperty("constant-parameters", jsonArray(jsonObject(
 *                                 jsonProperty("name", "x-route-blue-green"),
 *                                 jsonProperty("location", "header"),
 *                                 jsonProperty("value", "route-blue-green")
 *                             )))
 *                         )
 *                     ))
 *                 )))
 *             .pluginType("routing")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   default:
 *     type: alicloud:apigateway:Plugin
 *     properties:
 *       description: ${name}
 *       pluginName: ${name}
 *       pluginData:
 *         fn::toJSON:
 *           routes:
 *             - name: Vip
 *               condition: $CaAppId = 123456
 *               backend:
 *                 type: HTTP-VPC
 *                 vpcAccessName: slbAccessForVip
 *             - name: MockForOldClient
 *               condition: $ClientVersion < '2.0.5'
 *               backend:
 *                 type: MOCK
 *                 statusCode: 400
 *                 mockBody: This version is not supported!!!
 *             - name: BlueGreenPercent05
 *               condition: 1 = 1
 *               backend:
 *                 type: HTTP
 *                 address: https://beta-version.api.foo.com
 *               constant-parameters:
 *                 - name: x-route-blue-green
 *                   location: header
 *                   value: route-blue-green
 *       pluginType: routing
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Api Gateway Plugin can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:apigateway/plugin:Plugin example <id>
 * ```
 * @property description The description of the plug-in, which cannot exceed 200 characters.
 * @property pluginData The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
 * @property pluginName The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
 * @property pluginType The type of the plug-in. Valid values:
 * - "trafficControl"
 * - "ipControl"
 * - "backendSignature"
 * - "jwtAuth"
 * - "basicAuth"
 * - "cors"
 * - "caching"
 * - "routing"
 * - "accessControl"
 * - "errorMapping"
 * - "circuitBreaker"
 * - "remoteAuth"
 * - "logMask"
 * - "transformer".
 * @property tags The tag of the resource.
 */
public data class PluginArgs(
    public val description: Output<String>? = null,
    public val pluginData: Output<String>? = null,
    public val pluginName: Output<String>? = null,
    public val pluginType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.PluginArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.PluginArgs =
        com.pulumi.alicloud.apigateway.PluginArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .pluginData(pluginData?.applyValue({ args0 -> args0 }))
            .pluginName(pluginName?.applyValue({ args0 -> args0 }))
            .pluginType(pluginType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PluginArgs].
 */
@PulumiTagMarker
public class PluginArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var pluginData: Output<String>? = null

    private var pluginName: Output<String>? = null

    private var pluginType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the plug-in, which cannot exceed 200 characters.
     */
    @JvmName("bqotsyuqrrdkhtlk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
     */
    @JvmName("fvpvplhrtnihqxck")
    public suspend fun pluginData(`value`: Output<String>) {
        this.pluginData = value
    }

    /**
     * @param value The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
     */
    @JvmName("txryptmsrlskpyqp")
    public suspend fun pluginName(`value`: Output<String>) {
        this.pluginName = value
    }

    /**
     * @param value The type of the plug-in. Valid values:
     * - "trafficControl"
     * - "ipControl"
     * - "backendSignature"
     * - "jwtAuth"
     * - "basicAuth"
     * - "cors"
     * - "caching"
     * - "routing"
     * - "accessControl"
     * - "errorMapping"
     * - "circuitBreaker"
     * - "remoteAuth"
     * - "logMask"
     * - "transformer".
     */
    @JvmName("pphtmrjctmoeebkx")
    public suspend fun pluginType(`value`: Output<String>) {
        this.pluginType = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("tdlafxwtwwasftse")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the plug-in, which cannot exceed 200 characters.
     */
    @JvmName("ehnnuqvcheanixxk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
     */
    @JvmName("ufbjcefdayifkcch")
    public suspend fun pluginData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pluginData = mapped
    }

    /**
     * @param value The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
     */
    @JvmName("eksswqjyctpmpadw")
    public suspend fun pluginName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pluginName = mapped
    }

    /**
     * @param value The type of the plug-in. Valid values:
     * - "trafficControl"
     * - "ipControl"
     * - "backendSignature"
     * - "jwtAuth"
     * - "basicAuth"
     * - "cors"
     * - "caching"
     * - "routing"
     * - "accessControl"
     * - "errorMapping"
     * - "circuitBreaker"
     * - "remoteAuth"
     * - "logMask"
     * - "transformer".
     */
    @JvmName("sialpccucxxypnnq")
    public suspend fun pluginType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pluginType = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("dsgqejdfmqdcfmxs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("igjbkciddvavvkqj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PluginArgs = PluginArgs(
        description = description,
        pluginData = pluginData,
        pluginName = pluginName,
        pluginType = pluginType,
        tags = tags,
    )
}
