@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.AccessControlListAclEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aclEntryComment The description of the ACL.
 * @property aclEntryIp The entries that you want to add to the ACL. You can add CIDR blocks. Separate multiple CIDR blocks with commas (,).
 */
public data class AccessControlListAclEntryArgs(
    public val aclEntryComment: Output<String>? = null,
    public val aclEntryIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.AccessControlListAclEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.AccessControlListAclEntryArgs =
        com.pulumi.alicloud.apigateway.inputs.AccessControlListAclEntryArgs.builder()
            .aclEntryComment(aclEntryComment?.applyValue({ args0 -> args0 }))
            .aclEntryIp(aclEntryIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessControlListAclEntryArgs].
 */
@PulumiTagMarker
public class AccessControlListAclEntryArgsBuilder internal constructor() {
    private var aclEntryComment: Output<String>? = null

    private var aclEntryIp: Output<String>? = null

    /**
     * @param value The description of the ACL.
     */
    @JvmName("kntpiamkolydxxcv")
    public suspend fun aclEntryComment(`value`: Output<String>) {
        this.aclEntryComment = value
    }

    /**
     * @param value The entries that you want to add to the ACL. You can add CIDR blocks. Separate multiple CIDR blocks with commas (,).
     */
    @JvmName("jwrjdyxwqyfkkcfo")
    public suspend fun aclEntryIp(`value`: Output<String>) {
        this.aclEntryIp = value
    }

    /**
     * @param value The description of the ACL.
     */
    @JvmName("fjkysfddrqvsjoru")
    public suspend fun aclEntryComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclEntryComment = mapped
    }

    /**
     * @param value The entries that you want to add to the ACL. You can add CIDR blocks. Separate multiple CIDR blocks with commas (,).
     */
    @JvmName("rxegotyoywupuxdc")
    public suspend fun aclEntryIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclEntryIp = mapped
    }

    internal fun build(): AccessControlListAclEntryArgs = AccessControlListAclEntryArgs(
        aclEntryComment = aclEntryComment,
        aclEntryIp = aclEntryIp,
    )
}
