@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiConstantParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of Constant parameter.
 * @property in Constant parameter location; values: 'HEAD' and 'QUERY'.
 * @property name Constant parameter name.
 * @property value Constant parameter value.
 */
public data class ApiConstantParameterArgs(
    public val description: Output<String>? = null,
    public val `in`: Output<String>,
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiConstantParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiConstantParameterArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiConstantParameterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .`in`(`in`.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiConstantParameterArgs].
 */
@PulumiTagMarker
public class ApiConstantParameterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var `in`: Output<String>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The description of Constant parameter.
     */
    @JvmName("hieukmmonqnpxawe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Constant parameter location; values: 'HEAD' and 'QUERY'.
     */
    @JvmName("npddlfmtdckkojjj")
    public suspend fun `in`(`value`: Output<String>) {
        this.`in` = value
    }

    /**
     * @param value Constant parameter name.
     */
    @JvmName("vxitemwwnrnovytl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Constant parameter value.
     */
    @JvmName("klmecwcdtkfhlvre")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The description of Constant parameter.
     */
    @JvmName("lnxuocendqubuupx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Constant parameter location; values: 'HEAD' and 'QUERY'.
     */
    @JvmName("kcfjcierkbhggxhh")
    public suspend fun `in`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`in` = mapped
    }

    /**
     * @param value Constant parameter name.
     */
    @JvmName("yaijemeeixiankfi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Constant parameter value.
     */
    @JvmName("wcdvjluisgaploaq")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ApiConstantParameterArgs = ApiConstantParameterArgs(
        description = description,
        `in` = `in` ?: throw PulumiNullFieldException("in"),
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
