@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiFcServiceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arnRole RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
 * @property functionBaseUrl The base url of function compute service. Required if `function_type` is `HttpTrigger`.
 * @property functionName The function name of function compute service. Required if `function_type` is `FCEvent`.
 * @property functionType The type of function compute service. Supports values of `FCEvent`,`HttpTrigger`. Default value: `FCEvent`.
 * @property method The http method of function compute service. Required if `function_type` is `HttpTrigger`.
 * @property onlyBusinessPath Whether to filter path in `function_base_url`. Optional if `function_type` is `HttpTrigger`.
 * @property path The path of function compute service. Required if `function_type` is `HttpTrigger`.
 * @property qualifier The qualifier of function name of compute service.
 * @property region The region that the function compute service belongs to.
 * @property serviceName The service name of function compute service. Required if `function_type` is `FCEvent`.
 * @property timeout Backend service time-out time; unit: millisecond.
 */
public data class ApiFcServiceConfigArgs(
    public val arnRole: Output<String>,
    public val functionBaseUrl: Output<String>? = null,
    public val functionName: Output<String>? = null,
    public val functionType: Output<String>? = null,
    public val method: Output<String>? = null,
    public val onlyBusinessPath: Output<Boolean>? = null,
    public val path: Output<String>? = null,
    public val qualifier: Output<String>? = null,
    public val region: Output<String>,
    public val serviceName: Output<String>? = null,
    public val timeout: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiFcServiceConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiFcServiceConfigArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiFcServiceConfigArgs.builder()
            .arnRole(arnRole.applyValue({ args0 -> args0 }))
            .functionBaseUrl(functionBaseUrl?.applyValue({ args0 -> args0 }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .functionType(functionType?.applyValue({ args0 -> args0 }))
            .method(method?.applyValue({ args0 -> args0 }))
            .onlyBusinessPath(onlyBusinessPath?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .region(region.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .timeout(timeout.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiFcServiceConfigArgs].
 */
@PulumiTagMarker
public class ApiFcServiceConfigArgsBuilder internal constructor() {
    private var arnRole: Output<String>? = null

    private var functionBaseUrl: Output<String>? = null

    private var functionName: Output<String>? = null

    private var functionType: Output<String>? = null

    private var method: Output<String>? = null

    private var onlyBusinessPath: Output<Boolean>? = null

    private var path: Output<String>? = null

    private var qualifier: Output<String>? = null

    private var region: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
     */
    @JvmName("xmdvdxcvexpgebvr")
    public suspend fun arnRole(`value`: Output<String>) {
        this.arnRole = value
    }

    /**
     * @param value The base url of function compute service. Required if `function_type` is `HttpTrigger`.
     */
    @JvmName("xbitlvcyyeadtlhs")
    public suspend fun functionBaseUrl(`value`: Output<String>) {
        this.functionBaseUrl = value
    }

    /**
     * @param value The function name of function compute service. Required if `function_type` is `FCEvent`.
     */
    @JvmName("kwjiuselikcgycpk")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value The type of function compute service. Supports values of `FCEvent`,`HttpTrigger`. Default value: `FCEvent`.
     */
    @JvmName("hkoqrfibcqadwcrs")
    public suspend fun functionType(`value`: Output<String>) {
        this.functionType = value
    }

    /**
     * @param value The http method of function compute service. Required if `function_type` is `HttpTrigger`.
     */
    @JvmName("ganjsitjqkqbdcga")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Whether to filter path in `function_base_url`. Optional if `function_type` is `HttpTrigger`.
     */
    @JvmName("aynkchveyjlwscby")
    public suspend fun onlyBusinessPath(`value`: Output<Boolean>) {
        this.onlyBusinessPath = value
    }

    /**
     * @param value The path of function compute service. Required if `function_type` is `HttpTrigger`.
     */
    @JvmName("gcwvnhsviahrujqy")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The qualifier of function name of compute service.
     */
    @JvmName("bmvkmghfynxhroup")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value The region that the function compute service belongs to.
     */
    @JvmName("rrkakuhjkdbajfqa")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The service name of function compute service. Required if `function_type` is `FCEvent`.
     */
    @JvmName("souvjeyaehttqmyt")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Backend service time-out time; unit: millisecond.
     */
    @JvmName("nwmjgwjymplllpjy")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
     */
    @JvmName("fhameiaphljsurvi")
    public suspend fun arnRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arnRole = mapped
    }

    /**
     * @param value The base url of function compute service. Required if `function_type` is `HttpTrigger`.
     */
    @JvmName("mxtxddneuggwavoy")
    public suspend fun functionBaseUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionBaseUrl = mapped
    }

    /**
     * @param value The function name of function compute service. Required if `function_type` is `FCEvent`.
     */
    @JvmName("vuseuadopevqrqbs")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value The type of function compute service. Supports values of `FCEvent`,`HttpTrigger`. Default value: `FCEvent`.
     */
    @JvmName("usgjdjrpvhipwucg")
    public suspend fun functionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionType = mapped
    }

    /**
     * @param value The http method of function compute service. Required if `function_type` is `HttpTrigger`.
     */
    @JvmName("ytfcqepgxjebkbxb")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Whether to filter path in `function_base_url`. Optional if `function_type` is `HttpTrigger`.
     */
    @JvmName("fncwhudhfngvrhtj")
    public suspend fun onlyBusinessPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlyBusinessPath = mapped
    }

    /**
     * @param value The path of function compute service. Required if `function_type` is `HttpTrigger`.
     */
    @JvmName("owxfwgplystxhxqn")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The qualifier of function name of compute service.
     */
    @JvmName("laoxbdixliosyein")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value The region that the function compute service belongs to.
     */
    @JvmName("wdpyrypumbfsjvvl")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The service name of function compute service. Required if `function_type` is `FCEvent`.
     */
    @JvmName("igikqjcpylroygds")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Backend service time-out time; unit: millisecond.
     */
    @JvmName("nwpspyvvyifuitmd")
    public suspend fun timeout(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ApiFcServiceConfigArgs = ApiFcServiceConfigArgs(
        arnRole = arnRole ?: throw PulumiNullFieldException("arnRole"),
        functionBaseUrl = functionBaseUrl,
        functionName = functionName,
        functionType = functionType,
        method = method,
        onlyBusinessPath = onlyBusinessPath,
        path = path,
        qualifier = qualifier,
        region = region ?: throw PulumiNullFieldException("region"),
        serviceName = serviceName,
        timeout = timeout ?: throw PulumiNullFieldException("timeout"),
    )
}
