@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiHttpServiceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address The address of backend service.
 * @property aoneName The name of aone.
 * @property contentTypeCategory The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
 * @property contentTypeValue The content type value of backend service.
 * @property method The http method of backend service.
 * @property path The path of backend service.
 * @property timeout Backend service time-out time; unit: millisecond.
 */
public data class ApiHttpServiceConfigArgs(
    public val address: Output<String>,
    public val aoneName: Output<String>? = null,
    public val contentTypeCategory: Output<String>? = null,
    public val contentTypeValue: Output<String>? = null,
    public val method: Output<String>,
    public val path: Output<String>,
    public val timeout: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiHttpServiceConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiHttpServiceConfigArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiHttpServiceConfigArgs.builder()
            .address(address.applyValue({ args0 -> args0 }))
            .aoneName(aoneName?.applyValue({ args0 -> args0 }))
            .contentTypeCategory(contentTypeCategory?.applyValue({ args0 -> args0 }))
            .contentTypeValue(contentTypeValue?.applyValue({ args0 -> args0 }))
            .method(method.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .timeout(timeout.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiHttpServiceConfigArgs].
 */
@PulumiTagMarker
public class ApiHttpServiceConfigArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var aoneName: Output<String>? = null

    private var contentTypeCategory: Output<String>? = null

    private var contentTypeValue: Output<String>? = null

    private var method: Output<String>? = null

    private var path: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value The address of backend service.
     */
    @JvmName("sflmbscwkfrwbbxq")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The name of aone.
     */
    @JvmName("pgmcjankwqpcfuic")
    public suspend fun aoneName(`value`: Output<String>) {
        this.aoneName = value
    }

    /**
     * @param value The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
     */
    @JvmName("ouxvtlfqnbbehcab")
    public suspend fun contentTypeCategory(`value`: Output<String>) {
        this.contentTypeCategory = value
    }

    /**
     * @param value The content type value of backend service.
     */
    @JvmName("qrtajxtqyaxicpks")
    public suspend fun contentTypeValue(`value`: Output<String>) {
        this.contentTypeValue = value
    }

    /**
     * @param value The http method of backend service.
     */
    @JvmName("ovqqubtxfrsvfrgk")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value The path of backend service.
     */
    @JvmName("evsbaaxtjysckkvc")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Backend service time-out time; unit: millisecond.
     */
    @JvmName("rcvfongdjodmwfew")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The address of backend service.
     */
    @JvmName("cfdqpxbihmspmarf")
    public suspend fun address(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The name of aone.
     */
    @JvmName("crftsatiutnjxjrp")
    public suspend fun aoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aoneName = mapped
    }

    /**
     * @param value The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
     */
    @JvmName("plauulhjloflprws")
    public suspend fun contentTypeCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeCategory = mapped
    }

    /**
     * @param value The content type value of backend service.
     */
    @JvmName("eeoyemfhmbeejqoi")
    public suspend fun contentTypeValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeValue = mapped
    }

    /**
     * @param value The http method of backend service.
     */
    @JvmName("vtbraklvllwoffid")
    public suspend fun method(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The path of backend service.
     */
    @JvmName("arvwktprdddisyre")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Backend service time-out time; unit: millisecond.
     */
    @JvmName("nkbohdyxyemtriag")
    public suspend fun timeout(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ApiHttpServiceConfigArgs = ApiHttpServiceConfigArgs(
        address = address ?: throw PulumiNullFieldException("address"),
        aoneName = aoneName,
        contentTypeCategory = contentTypeCategory,
        contentTypeValue = contentTypeValue,
        method = method ?: throw PulumiNullFieldException("method"),
        path = path ?: throw PulumiNullFieldException("path"),
        timeout = timeout ?: throw PulumiNullFieldException("timeout"),
    )
}
