@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiHttpVpcServiceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aoneName The name of aone.
 * @property contentTypeCategory The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
 * @property contentTypeValue The content type value of backend service.
 * @property method The http method of backend service.
 * @property name The name of vpc instance.
 * @property path The path of backend service.
 * @property timeout Backend service time-out time. Unit: millisecond.
 * @property vpcScheme The vpc scheme of backend service which supports values of `HTTP` and `HTTPS`.
 */
public data class ApiHttpVpcServiceConfigArgs(
    public val aoneName: Output<String>? = null,
    public val contentTypeCategory: Output<String>? = null,
    public val contentTypeValue: Output<String>? = null,
    public val method: Output<String>,
    public val name: Output<String>,
    public val path: Output<String>,
    public val timeout: Output<Int>,
    public val vpcScheme: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiHttpVpcServiceConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiHttpVpcServiceConfigArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiHttpVpcServiceConfigArgs.builder()
            .aoneName(aoneName?.applyValue({ args0 -> args0 }))
            .contentTypeCategory(contentTypeCategory?.applyValue({ args0 -> args0 }))
            .contentTypeValue(contentTypeValue?.applyValue({ args0 -> args0 }))
            .method(method.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .timeout(timeout.applyValue({ args0 -> args0 }))
            .vpcScheme(vpcScheme?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiHttpVpcServiceConfigArgs].
 */
@PulumiTagMarker
public class ApiHttpVpcServiceConfigArgsBuilder internal constructor() {
    private var aoneName: Output<String>? = null

    private var contentTypeCategory: Output<String>? = null

    private var contentTypeValue: Output<String>? = null

    private var method: Output<String>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var vpcScheme: Output<String>? = null

    /**
     * @param value The name of aone.
     */
    @JvmName("mjuxymkxpilxalnq")
    public suspend fun aoneName(`value`: Output<String>) {
        this.aoneName = value
    }

    /**
     * @param value The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
     */
    @JvmName("muvqkugmkesamtup")
    public suspend fun contentTypeCategory(`value`: Output<String>) {
        this.contentTypeCategory = value
    }

    /**
     * @param value The content type value of backend service.
     */
    @JvmName("aeijgonddwywkoym")
    public suspend fun contentTypeValue(`value`: Output<String>) {
        this.contentTypeValue = value
    }

    /**
     * @param value The http method of backend service.
     */
    @JvmName("hlbhenljgotnpetp")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value The name of vpc instance.
     */
    @JvmName("qytuochqylplwlgc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The path of backend service.
     */
    @JvmName("tjupccruioxohvel")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Backend service time-out time. Unit: millisecond.
     */
    @JvmName("sigrkhlvlkgvjyii")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The vpc scheme of backend service which supports values of `HTTP` and `HTTPS`.
     */
    @JvmName("deawtcbpuhmnsfum")
    public suspend fun vpcScheme(`value`: Output<String>) {
        this.vpcScheme = value
    }

    /**
     * @param value The name of aone.
     */
    @JvmName("tfymcoiuqffjwysn")
    public suspend fun aoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aoneName = mapped
    }

    /**
     * @param value The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
     */
    @JvmName("uwouualocqfgylhg")
    public suspend fun contentTypeCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeCategory = mapped
    }

    /**
     * @param value The content type value of backend service.
     */
    @JvmName("subkvfxhfskpitpf")
    public suspend fun contentTypeValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeValue = mapped
    }

    /**
     * @param value The http method of backend service.
     */
    @JvmName("vfhenpeasqjnusdj")
    public suspend fun method(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The name of vpc instance.
     */
    @JvmName("nfddmpraoskrafhu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The path of backend service.
     */
    @JvmName("murebeyuaohbfyyl")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Backend service time-out time. Unit: millisecond.
     */
    @JvmName("vprfnrduxhgutydp")
    public suspend fun timeout(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The vpc scheme of backend service which supports values of `HTTP` and `HTTPS`.
     */
    @JvmName("eateshrkgqgfdjae")
    public suspend fun vpcScheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcScheme = mapped
    }

    internal fun build(): ApiHttpVpcServiceConfigArgs = ApiHttpVpcServiceConfigArgs(
        aoneName = aoneName,
        contentTypeCategory = contentTypeCategory,
        contentTypeValue = contentTypeValue,
        method = method ?: throw PulumiNullFieldException("method"),
        name = name ?: throw PulumiNullFieldException("name"),
        path = path ?: throw PulumiNullFieldException("path"),
        timeout = timeout ?: throw PulumiNullFieldException("timeout"),
        vpcScheme = vpcScheme,
    )
}
