@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiMockServiceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aoneName The name of aone.
 * @property result The result of the mock service.
 */
public data class ApiMockServiceConfigArgs(
    public val aoneName: Output<String>? = null,
    public val result: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiMockServiceConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiMockServiceConfigArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiMockServiceConfigArgs.builder()
            .aoneName(aoneName?.applyValue({ args0 -> args0 }))
            .result(result.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiMockServiceConfigArgs].
 */
@PulumiTagMarker
public class ApiMockServiceConfigArgsBuilder internal constructor() {
    private var aoneName: Output<String>? = null

    private var result: Output<String>? = null

    /**
     * @param value The name of aone.
     */
    @JvmName("cubppepgtiwmxcga")
    public suspend fun aoneName(`value`: Output<String>) {
        this.aoneName = value
    }

    /**
     * @param value The result of the mock service.
     */
    @JvmName("oqxaecgmticlawtk")
    public suspend fun result(`value`: Output<String>) {
        this.result = value
    }

    /**
     * @param value The name of aone.
     */
    @JvmName("kjspdflodslvlyaa")
    public suspend fun aoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aoneName = mapped
    }

    /**
     * @param value The result of the mock service.
     */
    @JvmName("xktnmsvdgiuwmvxy")
    public suspend fun result(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.result = mapped
    }

    internal fun build(): ApiMockServiceConfigArgs = ApiMockServiceConfigArgs(
        aoneName = aoneName,
        result = result ?: throw PulumiNullFieldException("result"),
    )
}
