@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiRequestConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bodyFormat The body format of the api, which support the values of 'STREAM' and 'FORM'.
 * @property method The method of the api, including 'GET','POST','PUT' etc.
 * @property mode The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
 * @property path The request path of the api.
 * @property protocol The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
 */
public data class ApiRequestConfigArgs(
    public val bodyFormat: Output<String>? = null,
    public val method: Output<String>,
    public val mode: Output<String>,
    public val path: Output<String>,
    public val protocol: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiRequestConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiRequestConfigArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiRequestConfigArgs.builder()
            .bodyFormat(bodyFormat?.applyValue({ args0 -> args0 }))
            .method(method.applyValue({ args0 -> args0 }))
            .mode(mode.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiRequestConfigArgs].
 */
@PulumiTagMarker
public class ApiRequestConfigArgsBuilder internal constructor() {
    private var bodyFormat: Output<String>? = null

    private var method: Output<String>? = null

    private var mode: Output<String>? = null

    private var path: Output<String>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value The body format of the api, which support the values of 'STREAM' and 'FORM'.
     */
    @JvmName("poqpjfiegxalwygt")
    public suspend fun bodyFormat(`value`: Output<String>) {
        this.bodyFormat = value
    }

    /**
     * @param value The method of the api, including 'GET','POST','PUT' etc.
     */
    @JvmName("rsyxohwohpibxdnm")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
     */
    @JvmName("mvimobqawjcrnyig")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The request path of the api.
     */
    @JvmName("hsehsihsvcvakfbi")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
     */
    @JvmName("oovkkpytgjhxtfrk")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The body format of the api, which support the values of 'STREAM' and 'FORM'.
     */
    @JvmName("jknhkgokcnhiidfy")
    public suspend fun bodyFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bodyFormat = mapped
    }

    /**
     * @param value The method of the api, including 'GET','POST','PUT' etc.
     */
    @JvmName("mqbhtbwnmdcerydn")
    public suspend fun method(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
     */
    @JvmName("dmdbxjsbwjrummjj")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The request path of the api.
     */
    @JvmName("iliqwbjsodgkbknp")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
     */
    @JvmName("jeqlgpglbvcgtvqq")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ApiRequestConfigArgs = ApiRequestConfigArgs(
        bodyFormat = bodyFormat,
        method = method ?: throw PulumiNullFieldException("method"),
        mode = mode ?: throw PulumiNullFieldException("mode"),
        path = path ?: throw PulumiNullFieldException("path"),
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
