@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiRequestParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultValue The default value of the parameter.
 * @property description The description of parameter.
 * @property in Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
 * @property inService Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
 * @property name Request's parameter name.
 * @property nameService Backend service's parameter name.
 * @property required Parameter required or not; values: REQUIRED and OPTIONAL.
 * @property type Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
 */
public data class ApiRequestParameterArgs(
    public val defaultValue: Output<String>? = null,
    public val description: Output<String>? = null,
    public val `in`: Output<String>,
    public val inService: Output<String>,
    public val name: Output<String>,
    public val nameService: Output<String>,
    public val required: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiRequestParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiRequestParameterArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiRequestParameterArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .`in`(`in`.applyValue({ args0 -> args0 }))
            .inService(inService.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .nameService(nameService.applyValue({ args0 -> args0 }))
            .required(required.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiRequestParameterArgs].
 */
@PulumiTagMarker
public class ApiRequestParameterArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var description: Output<String>? = null

    private var `in`: Output<String>? = null

    private var inService: Output<String>? = null

    private var name: Output<String>? = null

    private var nameService: Output<String>? = null

    private var required: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The default value of the parameter.
     */
    @JvmName("auskmbvfwbruwhci")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value The description of parameter.
     */
    @JvmName("fxfepyrsdsnncppc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
     */
    @JvmName("pafohtxeoyobcgas")
    public suspend fun `in`(`value`: Output<String>) {
        this.`in` = value
    }

    /**
     * @param value Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
     */
    @JvmName("sjnrvislaomdsjhh")
    public suspend fun inService(`value`: Output<String>) {
        this.inService = value
    }

    /**
     * @param value Request's parameter name.
     */
    @JvmName("emmmebdrmdtnvitj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Backend service's parameter name.
     */
    @JvmName("nvfvsfwiawhabeme")
    public suspend fun nameService(`value`: Output<String>) {
        this.nameService = value
    }

    /**
     * @param value Parameter required or not; values: REQUIRED and OPTIONAL.
     */
    @JvmName("tkwukmqcgyhfkmmw")
    public suspend fun required(`value`: Output<String>) {
        this.required = value
    }

    /**
     * @param value Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
     */
    @JvmName("fdnwunqfyytsmbfx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The default value of the parameter.
     */
    @JvmName("iuinosalqqiemkgx")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value The description of parameter.
     */
    @JvmName("bwdoifnxjrttjsde")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
     */
    @JvmName("bopicfunlxfvvtns")
    public suspend fun `in`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`in` = mapped
    }

    /**
     * @param value Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
     */
    @JvmName("ybtapofiahpdynca")
    public suspend fun inService(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inService = mapped
    }

    /**
     * @param value Request's parameter name.
     */
    @JvmName("errqetvuerupaosc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Backend service's parameter name.
     */
    @JvmName("qyirqnryawtyqwaj")
    public suspend fun nameService(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameService = mapped
    }

    /**
     * @param value Parameter required or not; values: REQUIRED and OPTIONAL.
     */
    @JvmName("rddlyglifejgucwv")
    public suspend fun required(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.required = mapped
    }

    /**
     * @param value Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
     */
    @JvmName("haqrypeysicynyih")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApiRequestParameterArgs = ApiRequestParameterArgs(
        defaultValue = defaultValue,
        description = description,
        `in` = `in` ?: throw PulumiNullFieldException("in"),
        inService = inService ?: throw PulumiNullFieldException("inService"),
        name = name ?: throw PulumiNullFieldException("name"),
        nameService = nameService ?: throw PulumiNullFieldException("nameService"),
        required = required ?: throw PulumiNullFieldException("required"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
