@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.ApiSystemParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property in System parameter location; values: 'HEAD' and 'QUERY'.
 * @property name System parameter name which supports values including in [system parameter list](https://www.alibabacloud.com/help/doc-detail/43677.html).
 * @property nameService Backend service's parameter name.
 */
public data class ApiSystemParameterArgs(
    public val `in`: Output<String>,
    public val name: Output<String>,
    public val nameService: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.ApiSystemParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.ApiSystemParameterArgs =
        com.pulumi.alicloud.apigateway.inputs.ApiSystemParameterArgs.builder()
            .`in`(`in`.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .nameService(nameService.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiSystemParameterArgs].
 */
@PulumiTagMarker
public class ApiSystemParameterArgsBuilder internal constructor() {
    private var `in`: Output<String>? = null

    private var name: Output<String>? = null

    private var nameService: Output<String>? = null

    /**
     * @param value System parameter location; values: 'HEAD' and 'QUERY'.
     */
    @JvmName("vraeglckynrwuuip")
    public suspend fun `in`(`value`: Output<String>) {
        this.`in` = value
    }

    /**
     * @param value System parameter name which supports values including in [system parameter list](https://www.alibabacloud.com/help/doc-detail/43677.html).
     */
    @JvmName("acmcejyttimjjova")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Backend service's parameter name.
     */
    @JvmName("cydxvhxpbkufjpxa")
    public suspend fun nameService(`value`: Output<String>) {
        this.nameService = value
    }

    /**
     * @param value System parameter location; values: 'HEAD' and 'QUERY'.
     */
    @JvmName("raedgasnlcwywqob")
    public suspend fun `in`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`in` = mapped
    }

    /**
     * @param value System parameter name which supports values including in [system parameter list](https://www.alibabacloud.com/help/doc-detail/43677.html).
     */
    @JvmName("wrwtckhilntqdmda")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Backend service's parameter name.
     */
    @JvmName("atycbewdkqgkhppj")
    public suspend fun nameService(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameService = mapped
    }

    internal fun build(): ApiSystemParameterArgs = ApiSystemParameterArgs(
        `in` = `in` ?: throw PulumiNullFieldException("in"),
        name = name ?: throw PulumiNullFieldException("name"),
        nameService = nameService ?: throw PulumiNullFieldException("nameService"),
    )
}
