@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.GetApisPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApis.
 * @property apiId The ID of the API.
 * @property groupId The ID of the API group.
 * @property ids A list of API IDs.
 * @property nameRegex A regex string to filter results by API name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetApisPlainArgs(
    public val apiId: String? = null,
    public val groupId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.GetApisPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.GetApisPlainArgs =
        com.pulumi.alicloud.apigateway.inputs.GetApisPlainArgs.builder()
            .apiId(apiId?.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApisPlainArgs].
 */
@PulumiTagMarker
public class GetApisPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var groupId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the API.
     */
    @JvmName("tcpovtwhhjcxoqvk")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value The ID of the API group.
     */
    @JvmName("bbvqrjygvtffgldn")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value A list of API IDs.
     */
    @JvmName("fjhdtwusaykugpyi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of API IDs.
     */
    @JvmName("grvqqlhdancfuqkw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by API name.
     */
    @JvmName("mcvuicidvfapjtkm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("uxqbffjceeujssdq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetApisPlainArgs = GetApisPlainArgs(
        apiId = apiId,
        groupId = groupId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
