@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.GetLogConfigsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLogConfigs.
 * @property ids A list of Log Config IDs.
 * @property logType The type the of log. Valid values: `PROVIDER`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetLogConfigsPlainArgs(
    public val ids: List<String>? = null,
    public val logType: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.GetLogConfigsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.GetLogConfigsPlainArgs =
        com.pulumi.alicloud.apigateway.inputs.GetLogConfigsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .logType(logType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogConfigsPlainArgs].
 */
@PulumiTagMarker
public class GetLogConfigsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var logType: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Log Config IDs.
     */
    @JvmName("pspqijahfroxlxyu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Log Config IDs.
     */
    @JvmName("doqoqworwovipmjf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The type the of log. Valid values: `PROVIDER`.
     */
    @JvmName("ynpvpuujbmuarvnc")
    public suspend fun logType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.logType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("liojbglljkyxcmax")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetLogConfigsPlainArgs = GetLogConfigsPlainArgs(
        ids = ids,
        logType = logType,
        outputFile = outputFile,
    )
}
