@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.GetModelsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getModels.
 * @property groupId The ID of the api group.
 * @property ids A list of Model IDs.
 * @property modelName The name of the Model.
 * @property nameRegex A regex string to filter results by Model name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetModelsPlainArgs(
    public val groupId: String,
    public val ids: List<String>? = null,
    public val modelName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.GetModelsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.GetModelsPlainArgs =
        com.pulumi.alicloud.apigateway.inputs.GetModelsPlainArgs.builder()
            .groupId(groupId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .modelName(modelName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModelsPlainArgs].
 */
@PulumiTagMarker
public class GetModelsPlainArgsBuilder internal constructor() {
    private var groupId: String? = null

    private var ids: List<String>? = null

    private var modelName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value The ID of the api group.
     */
    @JvmName("vuobqhrqokffabuc")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value A list of Model IDs.
     */
    @JvmName("xcnleubflpmnirec")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Model IDs.
     */
    @JvmName("bxbncjeoqxrypcyg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the Model.
     */
    @JvmName("ckboiwmjtvhxqcjl")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.modelName = mapped
    }

    /**
     * @param value A regex string to filter results by Model name.
     */
    @JvmName("rsclcxxortiilshs")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tejcbtcdcqxqavsj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("maeyufbgmpebcbdx")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ltgpqyttfrrolnrx")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetModelsPlainArgs = GetModelsPlainArgs(
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        ids = ids,
        modelName = modelName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
