@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.InstanceToConnectVpcIpBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlock The CIDR block of the VSwitch.
 * @property customized Specifies whether the IP block is customized.
 * @property vswitchId The VSwitch ID.
 * @property zoneId The zone ID.
 */
public data class InstanceToConnectVpcIpBlockArgs(
    public val cidrBlock: Output<String>,
    public val customized: Output<Boolean>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.InstanceToConnectVpcIpBlockArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.InstanceToConnectVpcIpBlockArgs =
        com.pulumi.alicloud.apigateway.inputs.InstanceToConnectVpcIpBlockArgs.builder()
            .cidrBlock(cidrBlock.applyValue({ args0 -> args0 }))
            .customized(customized?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceToConnectVpcIpBlockArgs].
 */
@PulumiTagMarker
public class InstanceToConnectVpcIpBlockArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var customized: Output<Boolean>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The CIDR block of the VSwitch.
     */
    @JvmName("koljdmqcmiusprbr")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value Specifies whether the IP block is customized.
     */
    @JvmName("rofodtjnxaclntno")
    public suspend fun customized(`value`: Output<Boolean>) {
        this.customized = value
    }

    /**
     * @param value The VSwitch ID.
     */
    @JvmName("brlxwpujrnkrrwkd")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID.
     */
    @JvmName("rooswntjrthiybwm")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The CIDR block of the VSwitch.
     */
    @JvmName("bpshcksasxlvvfps")
    public suspend fun cidrBlock(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value Specifies whether the IP block is customized.
     */
    @JvmName("yfxrmowqjueqpfib")
    public suspend fun customized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customized = mapped
    }

    /**
     * @param value The VSwitch ID.
     */
    @JvmName("cptihjggmcwskqoe")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID.
     */
    @JvmName("raqkaaqginrorxpa")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceToConnectVpcIpBlockArgs = InstanceToConnectVpcIpBlockArgs(
        cidrBlock = cidrBlock ?: throw PulumiNullFieldException("cidrBlock"),
        customized = customized,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
