@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.inputs

import com.pulumi.alicloud.apigateway.inputs.InstanceZoneVswitchSecurityGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlock The CIDR block of the VSwitch.
 * @property securityGroup The ID of the security group.
 * @property vswitchId The VSwitch ID.
 * @property zoneId The zone ID.
 */
public data class InstanceZoneVswitchSecurityGroupArgs(
    public val cidrBlock: Output<String>,
    public val securityGroup: Output<String>,
    public val vswitchId: Output<String>,
    public val zoneId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.apigateway.inputs.InstanceZoneVswitchSecurityGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.apigateway.inputs.InstanceZoneVswitchSecurityGroupArgs = com.pulumi.alicloud.apigateway.inputs.InstanceZoneVswitchSecurityGroupArgs.builder()
        .cidrBlock(cidrBlock.applyValue({ args0 -> args0 }))
        .securityGroup(securityGroup.applyValue({ args0 -> args0 }))
        .vswitchId(vswitchId.applyValue({ args0 -> args0 }))
        .zoneId(zoneId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceZoneVswitchSecurityGroupArgs].
 */
@PulumiTagMarker
public class InstanceZoneVswitchSecurityGroupArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var securityGroup: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The CIDR block of the VSwitch.
     */
    @JvmName("hfvrrnsgldlvlibp")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("rmbedueglphmaplx")
    public suspend fun securityGroup(`value`: Output<String>) {
        this.securityGroup = value
    }

    /**
     * @param value The VSwitch ID.
     */
    @JvmName("vigmyeawtlyhexic")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID.
     */
    @JvmName("tuxyijmfyorwcjwm")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The CIDR block of the VSwitch.
     */
    @JvmName("cqxalsqesvdrjysc")
    public suspend fun cidrBlock(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("petqosdytepmlnlm")
    public suspend fun securityGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroup = mapped
    }

    /**
     * @param value The VSwitch ID.
     */
    @JvmName("vehcxkytnpelxuhi")
    public suspend fun vswitchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID.
     */
    @JvmName("lgjutpayfaaqypnm")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceZoneVswitchSecurityGroupArgs = InstanceZoneVswitchSecurityGroupArgs(
        cidrBlock = cidrBlock ?: throw PulumiNullFieldException("cidrBlock"),
        securityGroup = securityGroup ?: throw PulumiNullFieldException("securityGroup"),
        vswitchId = vswitchId ?: throw PulumiNullFieldException("vswitchId"),
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
