@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of Constant parameter.
 * @property in Constant parameter location; values: 'HEAD' and 'QUERY'.
 * @property name Constant parameter name.
 * @property value Constant parameter value.
 */
public data class ApiConstantParameter(
    public val description: String? = null,
    public val `in`: String,
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.ApiConstantParameter): ApiConstantParameter = ApiConstantParameter(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            `in` = javaType.`in`(),
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
