@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arnRole RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
 * @property functionBaseUrl The base url of function compute service. Required if `function_type` is `HttpTrigger`.
 * @property functionName The function name of function compute service. Required if `function_type` is `FCEvent`.
 * @property functionType The type of function compute service. Supports values of `FCEvent`,`HttpTrigger`. Default value: `FCEvent`.
 * @property method The http method of function compute service. Required if `function_type` is `HttpTrigger`.
 * @property onlyBusinessPath Whether to filter path in `function_base_url`. Optional if `function_type` is `HttpTrigger`.
 * @property path The path of function compute service. Required if `function_type` is `HttpTrigger`.
 * @property qualifier The qualifier of function name of compute service.
 * @property region The region that the function compute service belongs to.
 * @property serviceName The service name of function compute service. Required if `function_type` is `FCEvent`.
 * @property timeout Backend service time-out time; unit: millisecond.
 */
public data class ApiFcServiceConfig(
    public val arnRole: String,
    public val functionBaseUrl: String? = null,
    public val functionName: String? = null,
    public val functionType: String? = null,
    public val method: String? = null,
    public val onlyBusinessPath: Boolean? = null,
    public val path: String? = null,
    public val qualifier: String? = null,
    public val region: String,
    public val serviceName: String? = null,
    public val timeout: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.ApiFcServiceConfig): ApiFcServiceConfig = ApiFcServiceConfig(
            arnRole = javaType.arnRole(),
            functionBaseUrl = javaType.functionBaseUrl().map({ args0 -> args0 }).orElse(null),
            functionName = javaType.functionName().map({ args0 -> args0 }).orElse(null),
            functionType = javaType.functionType().map({ args0 -> args0 }).orElse(null),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            onlyBusinessPath = javaType.onlyBusinessPath().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            qualifier = javaType.qualifier().map({ args0 -> args0 }).orElse(null),
            region = javaType.region(),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout(),
        )
    }
}
