@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aoneName The name of aone.
 * @property contentTypeCategory The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
 * @property contentTypeValue The content type value of backend service.
 * @property method The http method of backend service.
 * @property name The name of vpc instance.
 * @property path The path of backend service.
 * @property timeout Backend service time-out time. Unit: millisecond.
 * @property vpcScheme The vpc scheme of backend service which supports values of `HTTP` and `HTTPS`.
 */
public data class ApiHttpVpcServiceConfig(
    public val aoneName: String? = null,
    public val contentTypeCategory: String? = null,
    public val contentTypeValue: String? = null,
    public val method: String,
    public val name: String,
    public val path: String,
    public val timeout: Int,
    public val vpcScheme: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.ApiHttpVpcServiceConfig): ApiHttpVpcServiceConfig = ApiHttpVpcServiceConfig(
            aoneName = javaType.aoneName().map({ args0 -> args0 }).orElse(null),
            contentTypeCategory = javaType.contentTypeCategory().map({ args0 -> args0 }).orElse(null),
            contentTypeValue = javaType.contentTypeValue().map({ args0 -> args0 }).orElse(null),
            method = javaType.method(),
            name = javaType.name(),
            path = javaType.path(),
            timeout = javaType.timeout(),
            vpcScheme = javaType.vpcScheme().map({ args0 -> args0 }).orElse(null),
        )
    }
}
