@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bodyFormat The body format of the api, which support the values of 'STREAM' and 'FORM'.
 * @property method The method of the api, including 'GET','POST','PUT' etc.
 * @property mode The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
 * @property path The request path of the api.
 * @property protocol The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
 */
public data class ApiRequestConfig(
    public val bodyFormat: String? = null,
    public val method: String,
    public val mode: String,
    public val path: String,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.apigateway.outputs.ApiRequestConfig): ApiRequestConfig = ApiRequestConfig(
            bodyFormat = javaType.bodyFormat().map({ args0 -> args0 }).orElse(null),
            method = javaType.method(),
            mode = javaType.mode(),
            path = javaType.path(),
            protocol = javaType.protocol(),
        )
    }
}
